% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-MultiSampleSCPipeline.R
\name{sc_long_multisample_pipeline}
\alias{sc_long_multisample_pipeline}
\title{Pipeline for Multi-sample Single Cell Data (deprecated)}
\usage{
sc_long_multisample_pipeline(
  annotation,
  fastqs,
  outdir,
  genome_fa,
  minimap2 = NULL,
  barcodes_file = NULL,
  expect_cell_numbers = NULL,
  config_file = NULL
)
}
\arguments{
\item{annotation}{The file path to the annotation file in GFF3 format}

\item{fastqs}{The file path to input fastq file}

\item{outdir}{The path to directory to store all output files.}

\item{genome_fa}{The file path to genome fasta file.}

\item{minimap2}{Path to minimap2, optional.}

\item{barcodes_file}{The file with expected cell barcodes, with each barcode on a new line.}

\item{expect_cell_numbers}{The expected number of cells in the sample. This is used if
\code{barcodes_file} is not provided. See \code{BLAZE} for more details.}

\item{config_file}{File path to the JSON configuration file.}
}
\value{
A list of \code{SingleCellExperiment} objects, one for each sample.
}
\description{
This function is deprecated. Please use \code{\link{MultiSampleSCPipeline}}.
}
\examples{
reads <- ShortRead::readFastq(
  system.file("extdata", "fastq", "musc_rps24.fastq.gz", package = "FLAMES")
)
outdir <- tempfile()
dir.create(outdir)
dir.create(file.path(outdir, "fastq"))
bc_allow <- file.path(outdir, "bc_allow.tsv")
genome_fa <- file.path(outdir, "rps24.fa")
R.utils::gunzip(
  filename = system.file("extdata", "bc_allow.tsv.gz", package = "FLAMES"),
  destname = bc_allow, remove = FALSE
)
R.utils::gunzip(
  filename = system.file("extdata", "rps24.fa.gz", package = "FLAMES"),
  destname = genome_fa, remove = FALSE
)
ShortRead::writeFastq(reads[1:100],
  file.path(outdir, "fastq/sample1.fq.gz"), mode = "w", full = FALSE)
reads <- reads[-(1:100)]
ShortRead::writeFastq(reads[1:100],
  file.path(outdir, "fastq/sample2.fq.gz"), mode = "w", full = FALSE)
reads <- reads[-(1:100)]
ShortRead::writeFastq(reads,
  file.path(outdir, "fastq/sample3.fq.gz"), mode = "w", full = FALSE)

sce_list <- FLAMES::sc_long_multisample_pipeline(
  annotation = system.file("extdata", "rps24.gtf.gz", package = "FLAMES"),
  fastqs = c("sampleA" = file.path(outdir, "fastq"),
    "sample1" = file.path(outdir, "fastq", "sample1.fq.gz"),
    "sample2" = file.path(outdir, "fastq", "sample2.fq.gz"),
    "sample3" = file.path(outdir, "fastq", "sample3.fq.gz")),
  outdir = outdir,
  genome_fa = genome_fa,
  barcodes_file = rep(bc_allow, 4),
  config_file = create_config(
    outdir,
    pipeline_parameters.demultiplexer = "flexiplex"
  )
)

}
\seealso{
\code{\link{MultiSampleSCPipeline}} for the new pipeline interface,
\code{\link{SingleCellPipeline}} for single-sample pipeline,
\code{\link{BulkPipeline}} for bulk long data.
}
