% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadrant_plot.R
\name{quadrant_plot}
\alias{quadrant_plot}
\title{Generate Custom Quadrant Plots for Node Metrics}
\usage{
quadrant_plot(
  metrics,
  x_metric = "Degree",
  y_metric = "Redundancy",
  x_threshold = NULL,
  y_threshold = NULL,
  top_quantile = 0.95,
  point_size = 3
)
}
\arguments{
\item{metrics}{A \code{data.frame} containing computed node metrics.}

\item{x_metric}{Character. Column name to use for the x-axis. Default is \code{"Degree"}.}

\item{y_metric}{Character. Column name to use for the y-axis. Default is \code{"Redundancy"}.}

\item{x_threshold}{Numeric. X-axis threshold for quadrant separation. Default is \code{median(x_metric)}.}

\item{y_threshold}{Numeric. Y-axis threshold for quadrant separation. Default is \code{median(y_metric)}.}

\item{top_quantile}{Numeric. Quantile threshold (0-1) to highlight top nodes. Default is \code{0.95}.}

\item{point_size}{Numeric. Size of the points. Default is \code{3}.}
}
\value{
A \code{ggplot} object representing the customized quadrant plot.
}
\description{
This function visualizes relationships between \strong{any two node metrics} in a quadrant plot.
Quadrant labels dynamically adjust based on the selected X and Y axis metrics.
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  g <- load_graphml("Complete.graphml")

  # Compute node-level metrics
  result <- node_level_metrics(g)
  metrics <- result$metrics

  # Generate a quadrant plot using Degree and Efficiency
  plot <- quadrant_plot(metrics, x_metric = "Degree", y_metric = "Efficiency")
  print(plot)
}

}
