% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleEdgeQualityControl.R
\name{edgeLengthPlot}
\alias{edgeLengthPlot}
\title{edgeLengthPlot}
\usage{
edgeLengthPlot(annEdges, cutoffDF, whichPairs, xLim = 100, legend = FALSE)
}
\arguments{
\item{annEdges}{\itemize{
\item A data frame as produced by
edgeLengthsAndCellTypePairs
}}

\item{cutoffDF}{\itemize{
\item A data frame with columns cellTypePair and
cutoff. This defaults to NULL in which case no cutoffs will be
plotted.
}}

\item{whichPairs}{\itemize{
\item Which cellTypePairs to plot.  If this is NULL,
we plot all pairs.  If this is a numeric, we plot only pairs
that have at least this many edges.  If this is a character
vector, we plot the pairs in this list.
}}

\item{xLim}{\itemize{
\item limits the extent of the plots. Defaults to 100.  Can
be set to NULL.
}}

\item{legend}{\itemize{
\item Show legend, defaults to FALSE
}}
}
\value{
This returns a ggplot object
}
\description{
This plots histograms of the edge lengths broken out
by the cell types of the cells they connect.  It
optionally plots a cutoff for each pair of types.
}
\examples{
getExample = make.getExample()
centroids = getExample('centroids')
clusters = getExample('clusters')
delaunayNeighbours = getExample('delaunayNeighbours') 
annEdges =
   edgeLengthsAndCellTypePairs(delaunayNeighbours,clusters,centroids)
cutoffDF = edgeCutoffsByPercentile(annEdges,95)
g = edgeLengthPlot(annEdges,cutoffDF,whichPairs=60)
}
