% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleNeighbourhoods.R
\name{computeNeighboursDelaunay}
\alias{computeNeighboursDelaunay}
\title{This function computes a spatial graph where
neighbors are identified based on Delaunay triangulation.}
\usage{
computeNeighboursDelaunay(centroids)
}
\arguments{
\item{centroids}{\itemize{
\item a dataframe containing centroids
where rownames are cellnames and the first two columns
contain x and y coordinates respectively.
}}
}
\value{
a graph in neighbour format, i.e., a data frame with
columns nodeA and nodeB.
}
\description{
This function computes a spatial graph where
neighbors are identified based on Delaunay triangulation.
}
\examples{
centroids = make.getExample()('centroids')
delaunayNeighbours = computeNeighboursDelaunay(centroids)
}
