% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleNeighbourhoodAnalysis.R
\name{aggregateGeneExpression}
\alias{aggregateGeneExpression}
\title{This function takes a Seurat object and a list of
neighbourhoods and creates a Seurat object where the
columns are the neighbourhoods, the rows are are the
genes and the values are gene expression totals for
the cells in each neighbourhood}
\usage{
aggregateGeneExpression(
  f,
  neighbourhoods,
  self = FALSE,
  verbose = TRUE,
  returnType = "Seurat"
)
}
\arguments{
\item{f}{\itemize{
\item a Seurat object with layer counts or a SingleCellExperiment
to be turned into a Seurat object
}}

\item{neighbourhoods}{\itemize{
\item Neighbourhoods as given by a
collapsed expanded edge graph, as produced by
collapseNeighbourhoods. In particular, each cell should
appear as nodeA.
}}

\item{self}{\itemize{
\item include cell in its neighbourhood, defaults to FALSE
}}

\item{verbose}{\itemize{
\item used to control trace, defaults to TRUE
}}

\item{returnType}{\itemize{
\item Will return a SingleCellExperiment if this is either
of SCE, SingleCellExperiment or their lower-case equivalents.  Otherwise,
returns a Seurat object or SingleCellExperiment, depending on the
parameter returnType.
}}
}
\value{
a Seurat object giving total gene expression
in each neighbourhood or SingleCellExperiment
}
\description{
This function takes a Seurat object and a list of
neighbourhoods and creates a Seurat object where the
columns are the neighbourhoods, the rows are are the
genes and the values are gene expression totals for
the cells in each neighbourhood
}
\examples{
getExample = make.getExample()
smallXenium = getExample('smallXenium',toy=TRUE)
extendedNeighbours = getExample('extendedNeighbours',toy=TRUE)
agg = aggregateGeneExpression(smallXenium,extendedNeighbours,verbose=FALSE)
}
