% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctcbn.R
\name{ctcbnSingle}
\alias{ctcbnSingle}
\title{CT-CBN Single Batch}
\usage{
ctcbnSingle(
  dataset,
  bootstrapSamples = 0,
  randomSeed = 1,
  samplingRate = 1,
  epsilon = 2,
  numDrawnSamples = 0,
  numEmRuns = 1
)
}
\arguments{
\item{dataset}{\code{Spock} object with poset and pattern/lambda data.}

\item{bootstrapSamples}{Number of bootstrap samples (requires \code{epsilon} > 0, \code{numDrawnSamples} = 0)}

\item{randomSeed}{Random seed.}

\item{samplingRate}{Sampling rate.}

\item{epsilon}{If between 0 and 1, the fraction of violations allowed per edge. If negative, the interval 0 to 0.5 will be sampled equidistantly with N points and the output \code{Spock} will include multiple resulting posets.}

\item{numDrawnSamples}{If > 0, the number of samples to draw from the model. If zero (default), the model will be learned from data.}

\item{numEmRuns}{Number of em runs.}
}
\value{
A list of output data.
}
\description{
CT-CBN Single Batch
}
\examples{
examplePath <- getExamples()[1]
bc <- Spock$new(
    poset = readPoset(examplePath)$sets,
    numMutations = readPoset(examplePath)$mutations,
    genotypeMatrix = readPattern(examplePath)
)
ctcbnSingle(bc)
}
