% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSpillmat.R
\name{plotSpillmat}
\alias{plotSpillmat}
\title{Spillover matrix heatmap}
\usage{
plotSpillmat(
  x,
  sm = NULL,
  anno = TRUE,
  isotope_list = CATALYST::isotope_list,
  hm_pal = c("white", "lightcoral", "red2", "darkred"),
  anno_col = "black"
)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{sm}{spillover matrix to visualize. If NULL, \code{plotSpillmat} 
will try and access \code{metadata(x)$spillover_matrix}.}

\item{anno}{logical. If TRUE (default), spill percentages are shown inside 
bins and rows are annotated with the total amount of spill received.}

\item{isotope_list}{named list. Used to validate the input spillover matrix.
Names should be metals; list elements numeric vectors of their isotopes.
See \code{\link{isotope_list}} for the list of isotopes used by default.}

\item{hm_pal}{character vector of colors to interpolate.}

\item{anno_col}{character string specifying 
the color to use for bin annotations.}
}
\value{
a \code{ggplot2}-object showing estimated spill percentages 
  as a heatmap with colors ramped to the highest spillover value present.
}
\description{
Generates a heatmap of the spillover matrix
annotated with estimated spill percentages.
}
\examples{
# get single-stained control samples & construct SCE
data(ss_exp)
sce <- prepData(ss_exp)

# debarcode single-positive populations
bc_ms <- c(139, 141:156, 158:176)
sce <- assignPrelim(sce, bc_ms, verbose = FALSE)
sce <- applyCutoffs(estCutoffs(sce))

# estimate & visualize spillover matrix
sce <- computeSpillmat(sce)
plotSpillmat(sce)

}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
