% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{generateSpatialPlots}
\alias{generateSpatialPlots}
\title{Generate L-R interaction score spatial plots in a folder}
\usage{
generateSpatialPlots(
  scores,
  areas,
  plot.folder,
  width = 5,
  height = 3,
  pointsize = 8,
  rev.y = TRUE,
  ref.plot = TRUE,
  image.raster = NULL,
  x.col = "array_col",
  y.col = "array_row",
  label.col = "label",
  idSpatial.col = "idSpatial",
  cut.p = 0.01,
  low.color = "royalblue3",
  mid.color = "white",
  high.color = "orange",
  title.fs = 12,
  legend.fs = 10,
  axis.fs = 10,
  label.fs = 12,
  dot.size = 0.5,
  ref.colors = NULL
)
}
\arguments{
\item{scores}{A matrix of scores, one L-R interaction per row and
spatial locations in the columns. This matrix is typically obtained
from BulkSignalR functions \code{scoreLRGeneSignatures} or \code{scScoring}.}

\item{areas}{A data.frame containing at least the x and y
coordinates of the locations as well as the unique IDs of spatial locations.
In case \code{ref.plot} is set to TRUE,
a label column is required additionally.}

\item{plot.folder}{The folder name in which the plot files will be written.}

\item{width}{The width of each individual plot.}

\item{height}{The height of each individual plot.}

\item{pointsize}{PDF font point size.}

\item{rev.y}{A Boolean indicating whether low y coordinates should be
at the top of the plot.}

\item{ref.plot}{A Boolean indicating whether a reference map of the tissue
with area labels should be plot aside.}

\item{image.raster}{Raster object image to plot raw tissue image as
reference.}

\item{x.col}{Column name in \code{areas} containing x coordinates.}

\item{y.col}{Column name in \code{areas} containing y coordinates.}

\item{label.col}{Column name in \code{areas} containing area labels.}

\item{idSpatial.col}{Column name in \code{areas} containing the unique
IDs of spatial locations.}

\item{cut.p}{Proportion of top and bottom values for thresholding.}

\item{low.color}{Color for low score values.}

\item{mid.color}{Color for score = 0.}

\item{high.color}{Color for high score values.}

\item{title.fs}{Title font size.}

\item{legend.fs}{Legend items font size.}

\item{axis.fs}{Axis ticks font size.}

\item{label.fs}{Legend titles and axis names font size.}

\item{dot.size}{Dot size.}

\item{ref.colors}{A vector of colors to bypass those automatically chosen
by ggplot2 for the tissue areas in the reference plot.}
}
\value{
Create PDF file and returns `NULL`, invisibly.
}
\description{
Generate a series of individual spatial score plots in a folder.
Not limited to BulkSignalR gene signature scores.
}
\details{
A set of PDF files are created in the provided folder.
}
\examples{
data(bsrdm.spa, package = "BulkSignalR")
data(bsrinf.spa, package = "BulkSignalR")
data(annotation.spa, package = "BulkSignalR")

thres <- 0.01
bsrinf.red <- reduceToBestPathway(bsrinf.spa)
s.red  <- BSRSignature(bsrinf.red, qval.thres=thres)
scores.red <- scoreLRGeneSignatures(bsrdm.spa,s.red)

generateSpatialPlots(scores.red[1:2,],
annotation.spa, ".", label.col = "ground_truth")

}
