% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataPrepare.R
\name{.checkInteroperabilityForCounts}
\alias{.checkInteroperabilityForCounts}
\title{Internal function to check and extract a
count matrix if a more complex object than a simple matrix or data frame
is given as parameter. Main usage is to link with Bioconductor objects.}
\usage{
.checkInteroperabilityForCounts(
  counts,
  symbol.col,
  x.col,
  y.col,
  barcodeID.col
)
}
\arguments{
\item{counts}{A table or matrix of read counts (or protein abundance).
It can also be a SummarizedExperiment or SpatialExperiment
object from which the count matrix should be extracted.
See \code{\link{BSRDataModel}}.}

\item{symbol.col}{The index of the column containing the gene symbols in case
those are not the row names of \code{counts} already. In a
SpatialExperiment object, the index in the data frame returned by rowData().}

\item{x.col}{In a SpatialExperiment object, the index of the column
containing the x coordinates in the dafaframe returned by rowData(), usually 
named array_row.}

\item{y.col}{In a SpatialExperiment object, the index of the column
containing the y coordinates in the dafaframe returned by rowData(), usually 
named array_col.}

\item{barcodeID.col}{In a SpatialExperiment object, the index of the column
containing the barcodeID in the dafaframe returned by colData(), usually
named barcode_id.}
}
\value{
A matrix of count (or abundance) values
}
\description{
Internal function to check and extract a
count matrix if a more complex object than a simple matrix or data frame
is given as parameter. Main usage is to link with Bioconductor objects.
}
\keyword{internal}
