% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has_avworkspace-methods.R
\name{has_avworkspace-methods}
\alias{has_avworkspace-methods}
\alias{has_avworkspace,gcp-method}
\title{Helper to check AnVIL environment is set up to work with GCP}
\usage{
\S4method{has_avworkspace}{gcp}(strict = FALSE, ..., platform = cloud_platform())
}
\arguments{
\item{strict}{\code{logical(1)} Whether to include a check for an existing
\code{avworkspace_name()} setting. Default \code{FALSE}.}

\item{...}{Arguments passed to the methods.}

\item{platform}{A Platform derived class indicating the AnVIL environment,
currently, \code{azure} and \code{gcp} classes are compatible.}
}
\value{
\code{logical(1)} \code{TRUE} if the AnVIL environment is set up properly to
interact with GCP, otherwise \code{FALSE}.
}
\description{
\code{has_avworkspace()} checks that the AnVIL environment is set up
to work with GCP.  If \code{strict = TRUE}, it also checks that the workspace
name is set.
}
\section{Functions}{
\itemize{
\item \code{has_avworkspace(gcp)}: Check if the AnVIL environment is set up

}}
\examples{
has_avworkspace(platform = gcp())

}
