% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gadgets.R
\name{.gadget_run}
\alias{.gadget_run}
\title{Functions to implement AnVIL gadget interfaces}
\usage{
.gadget_run(title, tibble, DONE_FUN)
}
\arguments{
\item{title}{character(1) (required) title to appear at the base of
the gadget, e.g., "AnVIL Workspaces".}

\item{tibble}{a \code{tibble} or \code{data.frame} to be displayed in the
gadget.}

\item{DONE_FUN}{a function of two arguments, \code{tibble} and
\code{row_selected}. The tibble is the \code{tibble} provided as an
argument to \code{.gadget_run()}. \code{row_selected} is the row
selected in the gadget by the user. The function is only
invoked when the user selects a valid row.}
}
\value{
\code{.gadget_run()} returns the result of \code{DONE_FUN()} if a row
has been selected by the user, or \code{NULL} if no row is selected
(the user presses \code{Cancel}, or \code{Done} prior to selecting any
row).
}
\description{
Functions documented on this page are primarily
intended for package developers wishing to implement gadgets
(graphical interfaces) to navigating AnVIL-generated tables.

\code{.gadget_run()} presents the user with a
tibble-navigating gadget, returning the value of \code{DONE_FUN} if
a row of the tibble is selected, or NULL.
}
\examples{
\dontrun{
tibble <- avworkspaces()
DONE_FUN <- function(tibble, row_selected) {
    selected <- slice(tibble, row_selected)
    with(selected, paste0(namespace, "/", name))
}
.gadget_run("AnVIL Example", tibble, DONE_FUN)
}
}
