% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlphaMissense.R
\docType{data}
\name{ALPHAMISSENSE_RECORD}
\alias{ALPHAMISSENSE_RECORD}
\alias{am_browse}
\alias{am_available}
\alias{am_data}
\title{Retrieve AlphaMissense Resources as DuckDB Databases}
\format{
An object of class \code{character} of length 1.
}
\usage{
ALPHAMISSENSE_RECORD

am_browse(record = ALPHAMISSENSE_RECORD)

am_available(record = ALPHAMISSENSE_RECORD, bfc = BiocFileCache())

am_data(
    key,
    record = ALPHAMISSENSE_RECORD,
    bfc = BiocFileCache(),
    as = c("tbl", "tsv")
)
}
\arguments{
\item{record}{character(1) Zenodo record for the AlphaMissense data
resources.}

\item{bfc}{an object returned by \code{BiocFileCache()} representing the
location where downloaded files and the parsed database will be
stored. The default is the 'global' BiocFileCache.}

\item{key}{a character(1) 'key' from the result of
\code{am_available()}, or a single row of the tibble returned by
\code{am_available()}.}

\item{as}{chracter(1) type of return value.
\itemize{
\item \code{"tbl"}: a dbplyr tbl representation of the database resource.
\item \code{"tsv"}: path to the tsv.gz file representing the resource and
downloaded from Zenodo
}}
}
\value{
\code{am_available()} returns a tibble with columns \code{key},
\code{size}, and \code{link}. The meaning of key must be determined with
reference to the information at \code{am_browse()}.

\code{am_data()} returns a dbplyr (database) tibble
represented the downloaded and parsed file. Fields in the
database are as described on the Zenodo resource page.
}
\description{
\code{ALPHAMISSENSE_RECORD} is a constant identifier
corresponding to the default version of the AlphaMissense
resource to use.

\code{am_browse()} opens a web browser at the Zenodo record
for the AlphaMissense data.

\code{am_available()} reports available datasets in the
record.

\code{am_data()} retrieves a single \code{key} from the the
AlpahMissense Zenodo site and parses the file into a DuckDB
database.
}
\details{
\code{ALPHAMISSENSE_RECORD} can be set \strong{before the package is
loaded} with the environment variable of the same name, e.g.,
\code{Sys.setenv(ALPHAMISSENSE_RECORD = "10813168")}. The default is
the most recent version (version 3) as checked on 11 April,
2024.

\code{am_data()} uses BiocFileCache to download and store the
file and the corresponding DuckDB database.
}
\examples{
ALPHAMISSENSE_RECORD

if (interactive())
    am_browse()

am_available()

am_data("hg38")

## close the connection opened when adding the data
db_disconnect()

}
\keyword{datasets}
