% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateInput.R
\name{updateInput}
\alias{updateInput}
\title{Update the input}
\usage{
updateInput(
  workspaceName,
  inputs,
  config,
  workflowName = NULL,
  dry = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{workspaceName}{Name of the workspace}

\item{inputs}{A tibble containing new input values. Provide the modified
version of the current input table, which is the output from
\code{\link{currentInput}} function. IMPORTANT: all the attributes should be
provided as a character vector format and any string type attributes
(\code{inputType = String}) should have escaped quotation mark (\code{\"}).}

\item{config}{Workflow configuration. Output from the
\code{\link{getWorkflowConfig}} function.}

\item{workflowName}{Name of the workflow to run. If a single workflow is
available under the specified workspace, this function will check the input
of that workflow under the default (\code{NULL}). If there are multiple
workflows available, you should specify the workflow.}

\item{dry}{Logical(1). When \code{TRUE} (default), report the updated
configuration but do not perform the action requested in Terra. When
\code{FALSE}, inputs in Terra/AnVIL will updated.}

\item{verbose}{Logical(1). When \code{TRUE} (default), this function
will print the updated input.}
}
\value{
With \code{verbose=TRUE}, a list of updated inputs will be
printed. A successful execution of the function will update the input
configuration of the target workflow in Terra/AnVIL.
}
\description{
Update the input
}
\examples{
library(AnVILBase)
if (has_avworkspace(strict = TRUE, platform = AnVILGCP::gcp()) && "salmon" \%in\% avworkspaces()$name) {
config <- getWorkflowConfig(workspaceName = "salmon")
inputs <- currentInput("salmon", config)
## Modify the contents of 'inputs' table for your analysis
updateInput("salmon", inputs, config) 
}

}
