% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avworkflow-methods.R
\name{avworkflow-methods}
\alias{avworkflow-methods}
\alias{avworkflow_jobs,gcp-method}
\title{AnVIL workflow methods}
\usage{
\S4method{avworkflow_jobs}{gcp}(
  namespace = avworkspace_namespace(),
  name = avworkspace_name(),
  ...,
  platform = cloud_platform()
)
}
\arguments{
\item{namespace}{\code{character(1)} AnVIL workspace namespace as returned
by, e.g., \code{avworkspace_namespace()}}

\item{name}{\code{character(1)} AnVIL workspace name as returned by, eg.,
\code{avworkspace_name()}.}

\item{...}{Additional arguments passed to lower level functions (not used).}

\item{platform}{\code{gcp()} The cloud platform class to dispatch on as given by
\link[AnVILBase:cloud_platform]{AnVILBase::cloud_platform}. Typically not set manually as
\code{cloud_platform()} returns the \code{"gcp"} class for Google Cloud Platform
workspaces on AnVIL.}
}
\value{
\code{avworkflow_jobs()} returns a \code{tibble}, sorted by
\code{submissionDate}, with columns
\itemize{
\item submissionId character() job identifier from the workflow runner.
\item submitter character() AnVIL user id of individual submitting the job.
\item submissionDate POSIXct() date (in local time zone) of job submission.
\item status character() job status, with values 'Accepted' 'Evaluating'
'Submitting' 'Submitted' 'Aborting' 'Aborted' 'Done'
\item succeeded integer() number of workflows succeeding.
\item failed integer() number of workflows failing.
}
}
\description{
Methods for working with AnVIL workflow execution.
\code{avworkflow_jobs()} returns a tibble summarizing submitted workflow jobs for
a namespace and name.
}
\section{Functions}{
\itemize{
\item \code{avworkflow_jobs(gcp)}: List workflow jobs in the workspace

}}
\examples{
library(AnVILBase)
if (has_avworkspace(strict = TRUE, platform = gcp()))
    ## from within AnVIL
    avworkflow_jobs()
}
