% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avdata.R
\name{avdata}
\alias{avdata}
\alias{avdata_import}
\title{Import data into the current workspace}
\usage{
avdata(namespace = avworkspace_namespace(), name = avworkspace_name())

avdata_import(
  .data,
  namespace = avworkspace_namespace(),
  name = avworkspace_name()
)
}
\arguments{
\item{namespace}{\code{character(1)} AnVIL workspace namespace as returned
by, e.g., \code{avworkspace_namespace()}}

\item{name}{\code{character(1)} AnVIL workspace name as returned by, eg.,
\code{avworkspace_name()}.}

\item{.data}{A tibble or data.frame for import as an AnVIL table.}
}
\value{
\code{avdata()} returns a tibble with five columns: \code{"type"}
represents the origin of the data from the 'REFERENCE' or
'OTHER' data menus. \code{"table"} is the table name in the
\code{REFERENCE} menu, or 'workspace' for the table in the 'OTHER'
menu, the key used to access the data element, the value label
associated with the data element and the value (e.g., google
bucket) of the element.

\code{avdata_import()} returns, invisibly, the subset of the
input table used to update the AnVIL tables.
}
\description{
\code{avdata()} returns key-value tables representing the
information visualized under the DATA tab, 'REFERENCE DATA' and
'OTHER DATA' items.  \code{avdata_import()} updates (modifies or
creates new, but does not delete) rows in 'REFERENCE DATA' or
'OTHER DATA' tables.
}
\examples{
library(AnVILBase)
if (has_avworkspace(strict = TRUE, platform = gcp())) {
    ## from within AnVIL
    data <- avdata()
    data
    if (interactive())
        avdata_import(data)
}
}
