% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspace-dev-ops.R
\name{workspace-dev-ops}
\alias{workspace-dev-ops}
\alias{upload_tsv}
\alias{download_tsv}
\alias{delete_type_id}
\alias{add_type_id}
\alias{get_type_id}
\alias{delete_type}
\title{Functions to work with workspace data for developers}
\usage{
upload_tsv(
  tsv_file,
  type = tools::file_path_sans_ext(basename(tsv_file)),
  primaryKey = NULL
)

download_tsv(type)

delete_type_id(type, id)

add_type_id(row, type, id = row[[1L]])

get_type_id(type, id)

delete_type(type)
}
\arguments{
\item{tsv_file}{\code{character(1)} A path to a tab-separated values file}

\item{type}{\code{character(1)} A nickname for the uploaded dataset important for
retreival. By default, the file name will be used.}

\item{primaryKey}{\code{character(1)} The optional column name to uniquely
identify a record. By default, the first column is used as the primary
key and all values in the column must be unique.}

\item{id}{\code{character(1)} The value in the \code{primaryKey} column that
indicates the row to be removed.}

\item{row}{\code{tibble()} or \code{data.frame()} A single row to add to an existing
table. The row must have the same column names as the table. The
\code{primaryKey} column must be unique.}
}
\value{
\itemize{
\item \code{upload_tsv} - A response list indicating successful upload
\item \code{download_tsv} - A \code{tibble} corresponding to the data labeled with \code{type}
\item \code{delete_type_id}; \code{delete_type} - When successful, a \code{NULL} value
}
}
\description{
These group of functions will allow you to manipulate tables in
the "DATA" tab. Example operations include moving a flat Tab-Separated
Values (TSV) file into the workspace, deleting records, deleting tables,
adding a single row, retrieving a single row, and retrieving the data
table. Note that the API used refers to tables as \code{types}.
}
\details{
These functions use the Workspace Data Services (WDS) API. Current
operations that affect the "DATA" tab include:
\itemize{
\item \code{upload_tsv} - a \code{POST} request using a TSV file that populates the data
\item \code{download_tsv} - a \code{GET} request with the data name (\code{type} argument) in
\code{upload_tsv} to represent the data locally as a \code{tibble}
\item \code{delete_type_id} - a \code{DELETE} request to remove a record or row from
\code{type}
\item \code{add_type_id} - a \code{PUT} request to add a single row to an existing table
(\code{type})
\item \code{get_type_id} - a \code{GET} request to retrieve a single row from an existing
table (\code{type})
\item \code{delete_type} - a \code{DELETE} request to remove then entire data set
(\code{type})
}
}
\examples{
if (interactive()) {
  library(dplyr)
  type <- "model"
  mtcars_tbl <-
      mtcars |>
      as_tibble(rownames = "model_id") |>
      mutate(model_id = gsub(" ", "-", model_id))

  tsv_file <- tempfile()
  readr::write_tsv(mtcars_tbl, tsv_file)
  upload_tsv(
    tsv_file = tsv_file,
    type = "testData",
    primaryKey = "model_id"
  )

  download_tsv("testData")

  ## create an example single row tibble for add_type_id
  datsun <- filter(mtcars_tbl, model_id == "Datsun-710")
  ## change the model_id to be unique
  datsun[["model_id"]] <- "Datsun-512"

  add_type_id(row = datsun, type = "testData")

  get_type_id("testData", "Datsun-512")

  delete_type_id("testData", "Datsun-512")

  delete_type("testData")
}
}
\keyword{internal}
