% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_copy-helpers.R
\name{az_copy-helpers}
\alias{az_copy-helpers}
\alias{az_copy_from_storage}
\alias{az_copy_to_storage}
\alias{as.logical.azcopyStatus}
\alias{print.azcopyStatus}
\alias{summary.azcopyStatus}
\title{Azure Copy command line utility helpers}
\usage{
az_copy_from_storage(from, to = "./", recursive = FALSE, dry = TRUE)

az_copy_to_storage(from, to, recursive = FALSE, dry = TRUE)

\method{as.logical}{azcopyStatus}(x, ...)

\method{print}{azcopyStatus}(x, ..., verbose = FALSE)

\method{summary}{azcopyStatus}(object, ...)
}
\arguments{
\item{from}{\code{character(1)} A relative file path corresponding to
either the remote (\code{az_copy_from_storage}) or local (\code{az_copy_to_storage})
file location. Remote locations should be relative to the base directory in
the Azure Storage Container e.g., \code{analyses/jupyter.log}.}

\item{to}{\code{character(1)} A relative file path corresponding to
either the remote (\code{az_copy_to_storage}) or local (\code{az_copy_from_storage})
file location. Remote locations should be relative to the base directory in
the Azure Storage Container. When not specified, it will default to the
base directory of the remote location. The \code{to} path can be a folder path
but must end in a forward slash (\code{/}). If the \code{to} path points to a
non-existent directory, it will be created.}

\item{recursive}{\code{logical(1)} Whether to recursively move or remove files in
a directory. Only applies to \code{avremove}, \code{avbackup}, and \code{avrestore}.
Default is \code{TRUE} for \code{backup} and \code{restore} operations and \code{FALSE} for
\code{avremove}.}

\item{dry}{\code{logical(1)} Whether to perform a dry run i.e., add the
\code{--dry-run} flag to the command.}

\item{x}{\code{azcopyStatus} object to be checked; usually the output of \code{avcopy}
operations}

\item{...}{Additional arguments (not used).}

\item{verbose}{\code{logical(1)} Print the \code{INFO} lines from the \code{azcopy} output}

\item{object}{\code{azcopyStatus} object to be summarized; usually the output of
\code{avcopy} operations}
}
\value{
\itemize{
\item \code{az_copy_from_storage} - called for the side effect of copying a file
\strong{from} the Azure Storage Container
\item \code{az_copy_to_storage} - called for the side effect of copying a file \strong{to}
the Azure Storage Container
}
}
\description{
These functions invoke the \code{azcopy} command line utility. The
utilities make use of a managed SAS token to mainly transfer files from the
Azure workspace to the Azure Storage container. See \code{az_sas_token} for
credential details. The results of \verb{azcopy copy} commands are returned as
an \code{azcopyStatus} object which has S3 methods to print and convert to
logical.
}
\details{
\itemize{
\item \code{az_copy_from_storage} - copy a file from the Azure Storage Container to
the workspace environment
\item \code{az_copy_to_storage} - copy a file from the workspace environment to the
Azure Storage Container
}
}
\section{Functions}{
\itemize{
\item \code{as.logical(azcopyStatus)}: Convert results of azcopy operations to logical
values

\item \code{print(azcopyStatus)}: Print the results of \code{azcopy} operations

\item \code{summary(azcopyStatus)}: Get a summary of the results of \code{azcopy}
operations

}}
\examples{
if (interactive()) {

  ## local -> remote
  az_copy_to_storage("jupyter.log", "analyses/jupyter.log")
  az_copy_to_storage("jupyter.log", "analyses/test/")

  ## placed in the base storage UUID directory
  az_copy_to_storage("jupyter.log")

  ## remote -> local
  az_copy_from_storage("analyses/jupyter.log", "jupyter.log")
  ## download to the current directory
  az_copy_from_storage("analyses/jupyter.log")

}
}
\keyword{internal}
