% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avnotebooks-methods.R
\name{avnotebooks-methods}
\alias{avnotebooks-methods}
\alias{avnotebooks}
\alias{avnotebooks_localize}
\alias{avnotebooks_delocalize}
\alias{avnotebooks,azure-method}
\alias{avnotebooks_localize,azure-method}
\alias{avnotebooks_delocalize,azure-method}
\title{Azure Notebook Management}
\usage{
\S4method{avnotebooks}{azure}(local = FALSE, ..., platform = cloud_platform())

\S4method{avnotebooks_localize}{azure}(
  destination = "./analyses",
  dry = TRUE,
  ...,
  platform = cloud_platform()
)

\S4method{avnotebooks_delocalize}{azure}(
  source = "./",
  dry = TRUE,
  ...,
  platform = cloud_platform()
)
}
\arguments{
\item{local}{\code{logical(1)} notebooks located on the workspace
(\code{local = FALSE}, default) or runtime / local instance (\code{local = TRUE}).
When \code{local = TRUE}, the notebook path is
\verb{<workspace_data_service_url()>/analyses}.}

\item{...}{Additional arguments passed to lower level functions (not used)}

\item{platform}{\code{azure()} The cloud platform class to dispatch on as given by
\link[AnVILBase:cloud_platform]{AnVILBase::cloud_platform}. Typically not set manually as
\code{cloud_platform()} returns the \code{"azure"} class for Azure workspaces on
AnVIL.}

\item{destination}{\code{character(1)} or \code{missing} file path to the local file
system directory for synchronization. The default location is
\verb{~/<workspace_data_service_url()>/analyses}. Out-of-date local files are
replaced with the workspace version.}

\item{dry}{\code{logical(1)} Whether to perform a dry run i.e., add the
\code{--dry-run} flag to the command.}

\item{source}{\code{character(1)} or \code{missing} file path to the local file system
directory for synchronization. The default location is the home folder.
Out-of-date local files are replaced with the workspace version.}
}
\value{
\code{avnotebooks()} returns a character vector of files located
in the workspace 'analyses/' folder path, or on the local file
system.
}
\description{
\code{avnotebooks()} lists the notebooks in the current workspace.
}
\section{Functions}{
\itemize{
\item \code{avnotebooks(azure)}: List the notebooks in the current workspace

\item \code{avnotebooks_localize(azure)}: Sync notebooks between the Azure Blob Storage
Container and the local runtime

\item \code{avnotebooks_delocalize(azure)}: Sync notebooks between the local runtime and
the Azure Blob Storage Container

}}
\examples{
if (has_avworkspace(strict = TRUE, platform = azure()))
    avnotebooks()

}
