% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_helpers.R
\name{nmr_pca_plots}
\alias{nmr_pca_plots}
\alias{nmr_pca_plot_variance}
\alias{nmr_pca_scoreplot}
\alias{nmr_pca_loadingplot}
\title{Plotting functions for PCA}
\usage{
nmr_pca_plot_variance(pca_model)

nmr_pca_scoreplot(nmr_dataset, pca_model, comp = seq_len(2), ...)

nmr_pca_loadingplot(pca_model, comp)
}
\arguments{
\item{pca_model}{A PCA model trained with \link{nmr_pca_build_model}}

\item{nmr_dataset}{an \link{nmr_dataset_1D} object}

\item{comp}{Components to represent}

\item{...}{Additional aesthetics passed on to \link[ggplot2:aes]{ggplot2::aes} (use bare unquoted names)}
}
\value{
Plot of PCA
}
\description{
Plotting functions for PCA
}
\examples{
dataset_1D <- nmr_dataset_load(system.file("extdata", "nmr_dataset.rds", package = "AlpsNMR"))
model <- nmr_pca_build_model(dataset_1D)
nmr_pca_plot_variance(model)
nmr_pca_scoreplot(dataset_1D, model)
nmr_pca_loadingplot(model, 1)

}
\seealso{
Other PCA related functions: 
\code{\link{nmr_pca_build_model}()},
\code{\link{nmr_pca_outliers}()},
\code{\link{nmr_pca_outliers_filter}()},
\code{\link{nmr_pca_outliers_plot}()},
\code{\link{nmr_pca_outliers_robust}()}
}
\concept{PCA related functions}
