% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_normalize.R
\name{nmr_normalize}
\alias{nmr_normalize}
\alias{nmr_normalize_extra_info}
\title{Normalize nmr_dataset_1D samples}
\usage{
nmr_normalize(
  samples,
  method = c("area", "max", "value", "region", "pqn", "none"),
  ...
)

nmr_normalize_extra_info(samples)
}
\arguments{
\item{samples}{A \link{nmr_dataset_1D} object}

\item{method}{The criteria to be used for normalization
- area: Normalize to the total area
- max: Normalize to the maximum intensity
- value: Normalize each sample to a user defined value
- region: Integrate a region and normalize each sample to that region
- pqn: Use Probabalistic Quotient Normalization for normalization
- none: Do not normalize at all}

\item{...}{Method dependent arguments:
- \code{method == "value"}:
- \code{value}: A numeric vector with the normalization values to use
- \code{method == "region"}:
- \code{ppm_range}: A chemical shift region to integrate
- \code{...}: Other arguments passed on to \link{nmr_integrate_regions}}
}
\value{
The \link{nmr_dataset_1D} object, with the samples normalized.
Further information for diagnostic of the normalization process is also saved
and can be extracted by calling \code{nmr_normalize_extra_info()} afterwards.
}
\description{
The \code{nmr_normalize} function is used to normalize all the samples according
to a given criteria.
}
\details{
The aim is to correct from changes between samples, so no matter the criteria
used to normalize, once we get the factors (e.g. the areas), we divide them by
the median normalization factor to avoid introducing global scaling factors.

The \code{nmr_normalize_extra_info} function is used to extract additional information
after the normalization. Typically, we want to know what was the actual normalization
factor applied to each sample. The extra information includes a plot, representing
the dispersion of the normalization factor for each sample.
}
\examples{
nmr_dataset <- nmr_dataset_load(system.file("extdata", "nmr_dataset.rds", package = "AlpsNMR"))
nmr_dataset <- nmr_normalize(nmr_dataset, method = "area")
norm_dataset <- nmr_normalize(nmr_dataset)
norm_dataset$plot
nmr_dataset <- nmr_dataset_load(system.file("extdata", "nmr_dataset.rds", package = "AlpsNMR"))
nmr_dataset <- nmr_normalize(nmr_dataset, method = "area")
norm_extra_info <- nmr_normalize_extra_info(nmr_dataset)
norm_extra_info$plot
}
\seealso{
Other basic functions: 
\code{\link{nmr_exclude_region}()}
}
\concept{basic functions}
