% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_dataset_family.R
\name{filter.nmr_dataset_family}
\alias{filter.nmr_dataset_family}
\title{Keep samples based on metadata column criteria}
\usage{
\method{filter}{nmr_dataset_family}(.data, ...)
}
\arguments{
\item{.data}{An \link{nmr_dataset_family} object}

\item{...}{conditions, as in \link{dplyr}}
}
\value{
The same object, with the matching rows
}
\description{
Keep samples based on metadata column criteria
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -0.5, max = 10, by = 2.3E-4))

## example 1
sample_10 <- filter(dataset_1D, NMRExperiment == "10")

## example 2
# test_samples <- dataset_1D \%>\% filter(nmr_peak_table$metadata$external$Group == "placebo")
}
\seealso{
Other subsetting functions: 
\code{\link{[.nmr_dataset}()},
\code{\link{[.nmr_dataset_1D}()},
\code{\link{[.nmr_dataset_peak_table}()},
\code{\link{nmr_pca_outliers_filter}()}
}
\concept{subsetting functions}
