% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPedigree.R
\name{plotPedigree}
\alias{plotPedigree}
\title{Plot Pedigree}
\usage{
plotPedigree(
  nodelist,
  edgelist,
  sampling.design,
  out.pdf = NULL,
  output.dir = NULL,
  plot.width = 11,
  plot.height = 8,
  vertex.label = NULL,
  vertex.size = 12,
  aspect.ratio = 2.5
)
}
\arguments{
\item{nodelist}{input file containing information on generation times and pedigree lineages
"extdata" called "nodelist.fn"}

\item{edgelist}{input file containing edges "edgelist.fn"}

\item{sampling.design}{"progenitor.intermediate"; "sibling"; "progenitor.endpoint";"tree"}

\item{out.pdf}{output file name}

\item{output.dir}{output directory}

\item{plot.width}{plotting with}

\item{plot.height}{plotting height}

\item{vertex.label}{label vertix}

\item{vertex.size}{size of vertix}

\item{aspect.ratio}{aspect.ration}
}
\value{
plot pedigree matrices file.
}
\description{
Plotting Pedigree tree
}
\examples{
# Get some toy data
file <- system.file("extdata/dm/","nodelist.fn", package="AlphaBeta")
file2 <- system.file("extdata/dm/","edgelist.fn", package="AlphaBeta")
plotPedigree(nodelist = file, edgelist=file2, sampling.design="sibling",vertex.label=TRUE,
 out.pdf="Plot", output.dir=getwd() )
}
