% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxillary-methods.R
\docType{methods}
\name{phaseArray2phaseMatrix}
\alias{phaseArray2phaseMatrix}
\alias{phaseArray2phaseMatrix,array-method}
\title{phaseArray2phaseMatrix}
\usage{
phaseArray2phaseMatrix(x, ...)

\S4method{phaseArray2phaseMatrix}{array}(x, ...)
}
\arguments{
\item{x}{array see examples}

\item{...}{arguments to forward to internal functions}
}
\description{
used to convert the phase from the visually friendly matrix to array.
}
\details{
A more effectice way of store the phase data in the ASEset object
}
\examples{

#load data
data(ASEset)
a <- ASEset

#example phase matrix
p1 <- matrix(sample(c(1,0),replace=TRUE, size=nrow(a)*ncol(a)),nrow=nrow(a), ncol(a))
p2 <- matrix(sample(c(1,0),replace=TRUE, size=nrow(a)*ncol(a)),nrow=nrow(a), ncol(a))
p <- matrix(paste(p1,sample(c("|","|","/"), size=nrow(a)*ncol(a), replace=TRUE), p2, sep=""),
	nrow=nrow(a), ncol(a))

ar <- phaseMatrix2Array(p)

#Convert back
mat <- phaseArray2phaseMatrix(ar)

}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{phase}
