% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkage-methods.R
\docType{methods}
\name{lva}
\alias{lva}
\alias{lva,array-method}
\alias{lva,ASEset-method}
\title{lva}
\usage{
lva(x, ...)

\S4method{lva}{ASEset}(
  x,
  rv,
  region,
  settings = list(),
  return.class = "LinkVariantAlmlof",
  type = "lm",
  verbose = FALSE,
  covariates = matrix(),
  ...
)
}
\arguments{
\item{x}{ASEset object with phase and 'ref'/'alt' allele information}

\item{...}{arguments to forward to internal functions}

\item{rv}{RiskVariant object with phase and 'ref'/'alt' allele information}

\item{region}{RiskVariant object with phase and alternative allele information}

\item{settings}{RiskVariant object with phase and alternative allele information}

\item{return.class}{'LinkVariantAlmlof' (more options in future)}

\item{type}{"lm" or "nlme", "nlme" needs subject information}

\item{verbose}{logical, if set TRUE, then function will be more talkative}

\item{covariates}{add data.frame with covariates (only integers and numeric)}
}
\description{
make an almlof regression for arrays
}
\details{
internal method that takes one array with results from regionSummary
and one matrix with group information for each risk SNP (based on phase)
}
\examples{

data(ASEset) 
a <- ASEset
# Add phase
set.seed(1)
p1 <- matrix(sample(c(1,0),replace=TRUE, size=nrow(a)*ncol(a)),nrow=nrow(a), ncol(a))
p2 <- matrix(sample(c(1,0),replace=TRUE, size=nrow(a)*ncol(a)),nrow=nrow(a), ncol(a))
p <- matrix(paste(p1,sample(c("|","|","/"), size=nrow(a)*ncol(a), replace=TRUE), p2, sep=""),
	nrow=nrow(a), ncol(a))

phase(a) <- p

#add alternative allele information
mcols(a)[["alt"]] <- inferAltAllele(a)

#init risk variants
p.ar <- phaseMatrix2Array(p)
rv <- RiskVariantFromGRangesAndPhaseArray(x=GRvariants, phase=p.ar)

#colnames has to be samea and same order in ASEset and RiskVariant
colnames(a) <- colnames(rv)

# in this example each and every snp in the ASEset defines a region
r1 <- granges(a)

#use GRangesList to merge and use regions defined by each element of the
#GRangesList
r1b <- GRangesList(r1)
r1c <- GRangesList(r1, r1)

# in this example two overlapping subsets of snps in the ASEset defines the region
r2 <- split(granges(a)[c(1,2,2,3)],c(1,1,2,2))

# link variant almlof (lva)
lva(a, rv, r1)
lva(a, rv, r1b)
lva(a, rv, r1c)
lva(a, rv, r2)

# Use covariates (integers or nuemric)
cov <- data.frame(age=sample(20:70, ncol(a)), sex=rep(c(1,2), each=ncol(a)/2),  
row.names=colnames(a))
lva(a, rv, r1, covariates=cov)
lva(a, rv, r1b, covariates=cov)
lva(a, rv, r1c, covariates=cov)
lva(a, rv, r2, covariates=cov)

# link variant almlof (lva), using nlme
a2 <- a
ac <- assays(a2)[["countsPlus"]]
jit <- sample(c(seq(-0.10,0,length=5), seq(0,0.10,length=5)), size=length(ac) , replace=TRUE)
assays(a2, withDimnames=FALSE)[["countsPlus"]] <- round(ac * (1+jit),0)
ab <- cbind(a, a2)
colData(ab)[["subject.group"]] <- c(1:ncol(a),1:ncol(a))
rv2 <- rv[,c(1:ncol(a),1:ncol(a))]
colnames(ab) <- colnames(rv2)

lva(ab, rv2, r1, type="nlme")
lva(ab, rv2, r1b, type="nlme")
lva(ab, rv2, r1c, type="nlme")
lva(ab, rv2, r2, type="nlme")


}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{phase}
