% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference-methods.R
\docType{methods}
\name{inferAlleles}
\alias{inferAlleles}
\alias{inferAlleles,ASEset-method}
\title{inference of SNPs of ASEset}
\usage{
inferAlleles(
  x,
  strand = "*",
  return.type = "bi",
  threshold.frequency = 0,
  threshold.count.sample = 1,
  inferOver = "eachSample",
  allow.NA = FALSE
)
}
\arguments{
\item{x}{ASEset}

\item{strand}{strand to infer from}

\item{return.type}{'uni' 'bi' 'tri' 'quad' 'all'}

\item{threshold.frequency}{least fraction to classify (see details)}

\item{threshold.count.sample}{least amount of counts to try to infer allele}

\item{inferOver}{'eachSample' or 'allSamples'}

\item{allow.NA}{treat NA as zero when TRUE}
}
\description{
inference of SNPs
}
\details{
threshold.frequency is the least fraction needed to classify as bi tri or
quad allelic SNPs. If 'all' then all of bi tri and quad allelic SNPs will use the same
threshold. Everything under the treshold will be regarded as noise. 'all' will return 
a matrix with snps as rows and uni bi tri and quad will be columns. For this function
Anything that will return TRUE for tri-allelicwill also return TRUE for uni and bi-allelic
for the same SNP an Sample.
}
\examples{

data(ASEset)
i <- inferAlleles(ASEset)

}
\author{
Jesper R. Gadin
}
\keyword{infer}
