% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxillary-methods.R
\docType{methods}
\name{import-bcf}
\alias{import-bcf}
\alias{impBcfGRL}
\alias{impBcfGR}
\alias{impBcfGRL,character-method}
\alias{impBcfGR,character-method}
\title{Import Bcf Selection}
\usage{
impBcfGRL(UserDir, ...)

\S4method{impBcfGRL}{character}(UserDir, searchArea = NULL, verbose = TRUE, ...)

impBcfGR(UserDir, ...)

\S4method{impBcfGR}{character}(UserDir, searchArea = NULL, verbose = TRUE, ...)
}
\arguments{
\item{UserDir}{The relative or full path of folder containing bam files.}

\item{...}{parameters to pass on}

\item{searchArea}{A \code{GenomicRanges} object that contains the regions of
interest}

\item{verbose}{Setting \code{verbose=TRUE} gives details of the procedure
during function run.}
}
\value{
\code{BcfImpGRList} returns a GRangesList object.  \code{BcfImpGR}
returns one GRanges object of all unique entries from one or more bcf files.
}
\description{
Imports a selection of a bcf file or files specified by a GenomicRanges
object as search area.
}
\details{
A wrapper to import bcf files into R in the form of GenomicRanges objects.
}
\note{
Make sure there is a complementary index file \code{*.bcf.csi} for
each bcf file in \code{UserDir}. If there is not, then the functions
\code{impBcfGRL} and \code{impBcfGR} will try to create them.
}
\examples{

#Declare searchArea
searchArea <- GRanges(seqnames=c('17'), ranges=IRanges(79478301,79478361))

#Relative or full path
pathToFiles <- system.file('extdata/ERP000101_subset', package='AllelicImbalance')

#import
reads <- impBcfGRL(pathToFiles, searchArea, verbose=FALSE)

}
\seealso{
\itemize{ \item The impBamGRL for importing bam files
\item The \code{\link{getAlleleCounts}} for how to get allele(SNP) counts
\item The \code{\link{scanForHeterozygotes}} for how to find possible
heterozygote positions }
}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{bcf}
\keyword{import}
