% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecations.R
\name{import-bam-2}
\alias{import-bam-2}
\alias{impBamGRL}
\alias{impBamGRL.old}
\title{Import Bam-2}
\usage{
impBamGRL.old(UserDir, searchArea, verbose = TRUE)
}
\arguments{
\item{UserDir}{The relative or full path of folder containing bam files.}

\item{searchArea}{A \code{GenomicRanges object} that contains the regions of
interest}

\item{verbose}{Setting \code{verbose=TRUE} gives details of procedure during
function run.}
}
\value{
\code{impBamGRL} returns a GRangesList object containing the RNA-seq
reads in the region defined by the \code{searchArea} argument.
\code{impBamGAL} returns a list with GAlignments objects containing the
RNA-seq reads in the region defined by the \code{searchArea} argument.
\code{funImpBamGAPL} returns a list with GappedAlignmentPairs object
containing the RNA-seq reads in the region defined by the \code{searchArea}
argument.
}
\description{
Imports bla bal bal a specified genomic region from a bam file using a GenomicRanges
object as search area.
}
\details{
These functions are right  on tahea wrappers to import bam files into R and store them into
either GRanges, GAlignments or GappedAlignmentpairs objects.

It is recommended to use the impBamGAL() which takes information of gaps
into account. It is also possible to use the other variants as well, but
then pre-filtering becomes important keps to understand because gapped, intron-spanning reads
will cause problems. This is because the GRanges objects can not handle if
gaps are present and will then give a wrong result when calculating the
allele (SNP) count table.
}
\examples{

#Declare searchArea
searchArea <- GRanges(seqnames=c('17'), ranges=IRanges(79478301,79478361))

#Relative or full path
pathToFiles <- system.file('extdata/ERP000101_subset', package='AllelicImbalance')


}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{bam}
\keyword{import}
