% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\docType{methods}
\name{LinkVariantAlmlof-plot}
\alias{LinkVariantAlmlof-plot}
\alias{plot}
\alias{plot,LinkVariantAlmlof-method}
\alias{plot,LinkVariantAlmlof,ANY-method}
\title{plot LinkVariantAlmlof objects}
\usage{
plot(x, y, ...)

\S4method{plot}{LinkVariantAlmlof,ANY}(x, y, ...)
}
\arguments{
\item{x}{LinkVariantAlmlof object}

\item{y}{not used}

\item{...}{pass on arguments to internal methods}
}
\description{
plot an object of type LinkVariantAlmlof
}
\examples{

data(ASEset) 
a <- ASEset
# Add phase
set.seed(1)
p1 <- matrix(sample(c(1,0),replace=TRUE, size=nrow(a)*ncol(a)),nrow=nrow(a), ncol(a))
p2 <- matrix(sample(c(1,0),replace=TRUE, size=nrow(a)*ncol(a)),nrow=nrow(a), ncol(a))
p <- matrix(paste(p1,sample(c("|","|","/"), size=nrow(a)*ncol(a), replace=TRUE), p2, sep=""),
	nrow=nrow(a), ncol(a))

phase(a) <- p

#add alternative allele information
mcols(a)[["alt"]] <- inferAltAllele(a)

#init risk variants
p.ar <- phaseMatrix2Array(p)
rv <- RiskVariantFromGRangesAndPhaseArray(x=GRvariants, phase=p.ar)

#colnames has to be samea and same order in ASEset and RiskVariant
colnames(a) <- colnames(rv)

# in this example each and every snp in the ASEset defines a region
r1 <- granges(a)

# in this example two overlapping subsets of snps in the ASEset defines the region
r2 <- split(granges(a)[c(1,2,2,3)],c(1,1,2,2))

# link variant almlof (lva)
lv1 <- lva(a, rv, r1)
lv2 <- lva(a, rv, r2)
plot(lv2[1])

}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{plot}
