% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationplot-methods.R
\docType{methods}
\name{ASEset-glocationplot}
\alias{ASEset-glocationplot}
\alias{glocationplot}
\alias{glocationplot,ASEset-method}
\title{glocationplot ASEset objects}
\usage{
glocationplot(
  x,
  type = "fraction",
  strand = "*",
  BamGAL = NULL,
  GenomeAxisTrack = FALSE,
  trackNameDeAn = paste("deTrack", type),
  TxDb = NULL,
  sizes = NULL,
  add = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{an ASEset object.}

\item{type}{'fraction' or 'count'}

\item{strand}{'+','-','*' or 'both'. This argument determines which strand is
plotted. See \code{getAlleleCounts} for more information of choice of strand.}

\item{BamGAL}{GAlignmentsList covering the same genomic region as the ASEset}

\item{GenomeAxisTrack}{include an genomic axis track}

\item{trackNameDeAn}{trackname for deAnnotation track}

\item{TxDb}{a TxDb object which provides annotation}

\item{sizes}{vector with the sum 1. Describes the size of the tracks}

\item{add}{add to existing plot}

\item{verbose}{if set to TRUE it makes function more talkative}

\item{...}{arguments passed on to barplot function}
}
\description{
plotting ASE effects over a specific genomic region using Gviz functionality
}
\details{
The glocationplot methods visualises the distribution of ASE over a larger
region on one chromosome. It takes and ASEset object as well as additional
information on plot type (see \code{\link{gbarplot}}), strand type (see
\code{\link{getAlleleCounts}}), Annotation tracks are created from the Gviz
packageh. It is obviously important to make sure that the genome build used
is set correctly, e.g. 'hg19'.

sizes has to be of the same length as the number of tracks used.
}
\examples{

data(ASEset)
genome(ASEset) <- 'hg19'

glocationplot(ASEset,strand='+')

#for ASEsets with fewer SNPs the 'count' type plot is useful 
glocationplot(ASEset,type='count',strand='+')

}
\seealso{
\itemize{ \item The \code{\link{ASEset}} class which the
glocationplot function can be called up on.  }
}
\author{
Jesper R. Gadin
}
\keyword{glocationplot}
