% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importFimoBindingSites.R
\name{importFimoBindingSites}
\alias{importFimoBindingSites}
\title{Prepare binding site by fimo results}
\usage{
importFimoBindingSites(
  fimoGFFfiles,
  maximalBindingWidth = 40L,
  mergeBindingSitesByPercentage = 0.8,
  ignore.strand = TRUE,
  ...
)
}
\arguments{
\item{fimoGFFfiles}{Filenames of gff files of fimo output.}

\item{maximalBindingWidth}{A numeric vector(length=1).
Maximal binding site width. Default is 40.}

\item{mergeBindingSitesByPercentage}{A numeric vector (length=1).
The percentage of overlapping region of binding sites to merge as one
binding site.}

\item{ignore.strand}{When set to TRUE, the strand information is ignored in
the calculations.}

\item{...}{Parameter to be passed to \link[rtracklayer:GFFFile-class]{import.gff}}
}
\value{
A \code{\link[GenomicRanges:GRanges-class]{GenomicRanges}} with
all the positions of matches.
}
\description{
Prepare binding sites by given fimo gff files
}
\examples{
extdata <- system.file('extdata', package='ATACseqTFEA')
fimoGFFfiles <- dir(extdata, 'fimo.*.gff', full.names=TRUE)
mts <- importFimoBindingSites(fimoGFFfiles)
}
\author{
Jianhong Ou
}
