% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calWeights.R
\name{calWeights}
\alias{calWeights}
\title{Calculate the weights for binding score}
\usage{
calWeights(se, openscoreZcutoff = 0, ...)
}
\arguments{
\item{se}{An \link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment}
object. Outputs of \link{countsNormalization}.}

\item{openscoreZcutoff}{Open score Z value cutoff value. Default is 0.
Open score is calculated by the count ratio of
proximal site and distal site.}

\item{...}{Not used.}
}
\value{
A RangedSummarizedExperiment object with assays of
count matrix with bindingSites, proximalRegion and distalRegion as
column names and bindingSites GRanges object with the weights as rowRanges.
}
\description{
Use open score to calculate the weights for the binding score.
The open score is calculated by the counts of the proximal region divided by
the counts of the distal region. And the counts RangedSummarizedExperiment
will be filtered by the Z-score of the open score.
The weight is calculated by converting the Z score to the range of 0-1
following the normal distribution.
}
\examples{
bam <- system.file("extdata",
                   "KD.shift.rep1.bam",
                   package="ATACseqTFEA")
bsl <- system.file("extdata", "bindingSites.rds",
                   package="ATACseqTFEA")
bindingSites <- readRDS(bsl)
## get the count regions
bsEx <- expandBindingSites(bindingSites)
## count reads by 5'ends
res <- count5ends(bam, positive=0L, negative=0L,
                  bindingSites=bindingSites,
                  bindingSitesWithGap=bsEx$bindingSitesWithGap,
                  bindingSitesWithProximal=bsEx$bindingSitesWithProximal,
                  bindingSitesWithProximalAndGap=
                      bsEx$bindingSitesWithProximalAndGap,
                  bindingSitesWithDistal=bsEx$bindingSitesWithDistal)
## filter 0 counts in proximal
se <- eventsFilter(res, proximalRegion>0)
## normalize counts by width of count region
se <- countsNormalization(se, proximal=40, distal=40)
## calculate the weights
calWeights(se)
}
\author{
Jianhong Ou
}
