% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeListOfGAlignments.R
\name{writeListOfGAlignments}
\alias{writeListOfGAlignments}
\title{export list of GAlignments into bam files}
\usage{
writeListOfGAlignments(objs, outPath = ".")
}
\arguments{
\item{objs}{A list of \link[GenomicAlignments:GAlignments-class]{GAlignments}.}

\item{outPath}{character(1). Output file path.}
}
\value{
status of export.
}
\description{
wraper for \link[BiocIO:export]{export} to export list of 
GAlignment into bam files.
}
\examples{
library(GenomicAlignments)
gal1 <- GAlignments(seqnames=Rle("chr1"), pos=1L, cigar="10M",
                    strand=Rle(strand(c("+"))), names="a", score=1)
galist <- GAlignmentsList(a=gal1)
writeListOfGAlignments(galist)
}
\author{
Jianhong Ou
}
