% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiftGAlignments.R
\name{shiftGAlignments}
\alias{shiftGAlignments}
\title{shift 5' ends for single end reads}
\usage{
shiftGAlignments(gal, positive = 4L, negative = 5L, outbam)
}
\arguments{
\item{gal}{An object of 
\link[GenomicAlignments:GAlignments-class]{GAlignments}.}

\item{positive}{integer(1). the size to be shift for positive strand}

\item{negative}{integer(1). the size to be shift for negative strand}

\item{outbam}{file path to save shift reads. 
If missing, no file will be write.}
}
\value{
An object of 
\link[GenomicAlignments:GAlignments-class]{GAlignments} with 5' end 
shifted reads.
}
\description{
shift the GAlignmentsLists by 5' ends. 
All reads aligning to the positive strand will be offset by +4bp, 
and all reads aligning to the negative strand will be offset -5bp by default.
}
\examples{
bamfile <- system.file("extdata", "GL1.bam", package="ATACseqQC")
tags <- c("AS", "XN", "XM", "XO", "XG", "NM", "MD", "YS", "YT")
library(BSgenome.Hsapiens.UCSC.hg19)
which <- as(seqinfo(Hsapiens)["chr1"], "GRanges")
gal <- readBamFile(bamfile, tag=tags, 
                   what=c("qname", "flag", "mapq", "seq", "qual"),
                   which=which, asMates=FALSE, bigFile=TRUE)
objs <- shiftGAlignments(gal)
export(objs, "shift.bam")
}
\author{
Jianhong Ou
}
