% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-class.R, R/ASICSResults-class.R
\name{visualisation-methods-spectra}
\alias{visualisation-methods-spectra}
\alias{plot,Spectra,ANY-method}
\alias{plot.Spectra}
\alias{plot,ASICSResults,ANY-method}
\alias{plot.ASICSResults}
\title{Visualisation methods}
\usage{
\S4method{plot}{Spectra,ANY}(x, y, xlim = c(0.5, 10), ylim = NULL, ...)

\S4method{plot}{ASICSResults,ANY}(
  x,
  y,
  idx = 1,
  xlim = c(0.5, 10),
  ylim = NULL,
  pure.library = NULL,
  add.metab = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \linkS4class{Spectra},
\linkS4class{PureLibrary} or \linkS4class{ASICSResults}.}

\item{y}{Currently not used.}

\item{xlim, ylim}{Boundaries for x and y, respectively.}

\item{...}{Currently not used.}

\item{idx}{Index of the spectrum to plot. Default to 1.}

\item{pure.library}{Pure library used for the quantification. Default to
\code{NULL} (in which case, the library included in the package is used).}

\item{add.metab}{Name of one metabolite to add to the plot. Default to
\code{NULL} (in which case, no pure spectrum added to the plot).}
}
\value{
\itemize{
\item A \code{\link[ggplot2]{ggplot}} plot of all spectra (or of a subset) on
the same figure for \linkS4class{Spectra} and \linkS4class{PureLibrary}
objects.
\item A \code{\link[ggplot2]{ggplot}} plot of original and reconstructed
spectra of one sample in the same figure for \linkS4class{ASICSResults}
object. In addition, one pure metabolite spectrum (as provided in the
reference library) and the deformed one can be superimposed to the plot.
}
}
\description{
Methods available to plot one object in ASICS package.
}
\examples{
# Import data and create object
current_path <- system.file("extdata", "example_spectra", package = "ASICS")
spectra_data <- importSpectraBruker(current_path)
spectra_obj <- createSpectra(spectra_data)
spectra_obj <- createSpectra(spectra_data)

# Plot the spectra
plot(spectra_obj)
}
