% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAlignment.R
\name{plotAlignment}
\alias{plotAlignment}
\title{Tile plot}
\usage{
plotAlignment(spectra_obj, xlim = c(0, 10))
}
\arguments{
\item{spectra_obj}{An object of class \linkS4class{Spectra} obtained with the
function \link{createSpectra}.}

\item{xlim}{Boundaries for x.}
}
\value{
A \code{\link[ggplot2]{ggplot}} plot of original and reconstructed
spectra of one sample in the same figure for \linkS4class{ASICSResults}
object. In addition, one pure metabolite spectrum (as provided in the
reference library) and the deformed one can be superimposed to the plot.
}
\description{
Tile plot of spectra to see if an alignment is needed or the result of an
alignment.
}
\examples{
# Import data and create object
current_path <- system.file("extdata", "example_spectra", package = "ASICS")
spectra_data <- importSpectraBruker(current_path)
spectra_obj <- createSpectra(spectra_data)
plotAlignment(spectra_obj, xlim = c(3,4))


}
\seealso{
\code{\link{alignSpectra}}
}
