% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-class.R
\docType{class}
\name{Spectra-class}
\alias{Spectra-class}
\title{Class \linkS4class{Spectra}}
\description{
Objects of class \linkS4class{Spectra} contain a set of NMR spectra.
It includes preprocessed spectra and can be created with the function
\code{\link{createSpectra}}.
}
\section{Slots}{

\describe{
\item{\code{sample.name}}{Character vector of sample names.}

\item{\code{ppm.grid}}{Numeric vector of a unique grid (definition domain) for all
spectra (in ppm).}

\item{\code{spectra}}{Numeric matrix with all spectra in columns. Columns must be in
the same order as for \code{sample.name} and rows correspond to points of
\code{ppm.grid}.}

\item{\code{norm.method}}{Character specifying the normalisation method to use on
spectra}

\item{\code{norm.params}}{List containing normalisation parameteres (see
\code{\link{normaliseSpectra}} for details).}
}}

\section{Methods}{

  Multiple methods can be applied on \linkS4class{Spectra} objects.
  \itemize{
    \item As usual for S4 object, show and summary methods are available, see
    \link[=summary-methods]{Object summary}
    \item All slots have an accessor \code{get_slot name}, see
    \link[=accessors-methods]{Accessors}
    \item Two objects can be combined or a subset can be extracted, see
    \link[=combineAndSubset-methods]{Combine and subset methods}
    \item All spectra contained in an object can be represented in a plot,
    see \link[=visualisation-methods-spectra]{Visualisation methods}
  }
}

