% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASICS.R
\name{ASICS}
\alias{ASICS}
\title{Automatic Statistical Identification in Complex Spectra}
\usage{
ASICS(
  spectra_obj,
  exclusion.areas = matrix(c(4.5, 5.1), ncol = 2),
  max.shift = 0.02,
  pure.library = NULL,
  noise.thres = 0.02,
  joint.align = TRUE,
  threshold.noise = NULL,
  combine = NULL,
  add.noise = 0.15,
  mult.noise = 0.172,
  quantif.method = c("FWER", "Lasso", "both"),
  clean.thres = 1,
  ref.spectrum = NULL,
  seed = 1234,
  ncores = 1,
  verbose = TRUE
)
}
\arguments{
\item{spectra_obj}{An object of class \linkS4class{Spectra} obtained with the
function \link{createSpectra}.}

\item{exclusion.areas}{Definition domain of spectra that has to be excluded
for the quantification (ppm). By default, the water region is excluded
(4.5-5.1 ppm).}

\item{max.shift}{Maximum chemical shift allowed (in ppm). Default to 0.02.}

\item{pure.library}{An object of class \linkS4class{PureLibrary} containing
the reference spectra (pure metabolite spectra). If \code{NULL}, the library
included in the package (that contains 191 reference spectra) is used.}

\item{noise.thres}{Threshold for signal noise. Default to 0.02.}

\item{joint.align}{Logical. If \code{TRUE}, information from all spectra is
taken into account to align individual library.}

\item{threshold.noise}{DEPRECATED, use \code{noise.thres} instead.}

\item{combine}{DEPRECATED, use \code{joint.align} instead.}

\item{add.noise, mult.noise}{additive and multiplicative noises. To set these
noises, you can compute the standard deviation in a noisy area for
\code{add.noise} or the standard deviation in a peak area for
\code{mult.noise} when several spectra of the same sample are available.
By default, \code{add.noise = 0.15} and \code{mult.noise = 0.172}}

\item{quantif.method}{either \code{"FWER"} to perform an independent
quantification (the method available in ASICS since the beginning),
\code{"Lasso"} to perform a joint quantification (all the spectra together)
or \code{"both"} to perform a joint quantification after the FWER selection
of the independent quantification. More details can be founded in the
user's guide.}

\item{clean.thres}{if \code{quantif.method == "both"} the percentage of
spectra in which the metabolite needs to be identified by the FWER selection.
Default to 1, \emph{i.e.} metabolite is quantified if it was identified
in at least 1\% of the spectra.}

\item{ref.spectrum}{index of the reference spectrum used for the alignment.
Default to \code{NULL}, \emph{i.e.} the reference spectrum is automatically
detected.}

\item{seed}{Random seed to control randomness in the algorithm (used in the
estimation of the significativity of a given metabolite concentration).}

\item{ncores}{Number of cores used in parallel evaluation. Default to
\code{1}.}

\item{verbose}{A Boolean value to allow print out process information.}
}
\value{
An object of type \linkS4class{ASICSResults} containing the
quantification results.
}
\description{
Quantification of 1D 1H NMR spectra with ASICS method using a library of
pure metabolite spectra. The method is presented in Tardivel et al. (2017).
}
\note{
Since version 2.3.1 small changes were applied in order to improve the
speed of metabolite selection algorithm, which can slightly impact outputs
of the method.
}
\examples{
# Import data and create object
current_path <- system.file("extdata", package = "ASICS")
spectra_data <- importSpectra(name.dir = current_path,
                     name.file = "spectra_example.txt", type.import = "txt")
spectra_obj <- createSpectra(spectra_data)

# Estimation of relative quantifications
to_exclude <- matrix(c(4.5, 10), ncol = 2)
resASICS <- ASICS(spectra_obj, exclusion.areas = to_exclude,
                  joint.align = FALSE, quantif.method = "FWER")
}
\references{
Tardivel P., Canlet C., Lefort G., Tremblay-Franco M., Debrauwer
L., Concordet D., Servien R. (2017). ASICS: an automatic method for
identification and quantification of metabolites in complex 1D 1H NMR
spectra. \emph{Metabolomics}, \strong{13}(10): 109.
\url{https://doi.org/10.1007/s11306-017-1244-5}
}
\seealso{
\linkS4class{ASICSResults} \code{\link{pure_library}}
\code{\link{createSpectra}}
}
