#' Pure spectra library
#'
#' The 1D 1H NMR spectra of 191 reference compounds were collected to build the
#' default library of reference spectra. These compounds have been prepared and
#' measured using a Bruker Avance III HD spectrometer in the MetaToul - AXIOM
#' Site at Toulouse (France). For more details on the preparation, please see
#' Tardivel et al. (2017).
#'
#' @name pure_library
#'
#' @docType data
#'
#' @format A \linkS4class{PureLibrary} object with 4 entries:
#' \describe{
#'   \item{sample.name}{names of the metabolites}
#'   \item{ppm.grid}{common grid for all spectra}
#'   \item{spectra}{data frame with each pure metabolite spectrum in column}
#'   \item{nb.protons}{number of protons of each metabolite}
#' }
#'
#' @references Tardivel P., Canlet C., Lefort G., Tremblay-Franco M., Debrauwer
#' L., Concordet D., Servien R. (2017). ASICS: an automatic method for
#' identification and quantification of metabolites in complex 1D 1H NMR
#' spectra. \emph{Metabolomics}, \strong{13}(10): 109.
#' \url{https://doi.org/10.1007/s11306-017-1244-5}

NULL

