% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeScaleMatrix.r
\name{aldex.makeScaleMatrix}
\alias{aldex.makeScaleMatrix}
\title{Generate a differential scale matrix by group}
\usage{
aldex.makeScaleMatrix(gamma, mu, conditions, log = TRUE, mc.samples = 128)
}
\arguments{
\item{gamma}{- the base gamma value for the sdlog parameter of rlnorm}

\item{mu}{- pair of values, or a vector of values one for each sample}

\item{conditions}{- the conditions vector for the dataset}

\item{log}{- scale ratio in log2 (TRUE) or as simple ratio (FALSE)}

\item{mc.samples}{- the number of Monte-Carlo instances used by aldex()}
}
\value{
returns a matrix of gamma values that are used as an estimate
of the scale for the aldex.clr() function.
This allows different scale and gamma values to be applied to each group
and can move the centre of mass of the data if required. The example dataset
has very extreme differences in scale. Most often these are likely in the
range of 10-15% of the base scale.
}
\description{
Takes as input the conditions vector, dispersion paramenter, starting
scale values and the number of random instances. The ratio between the 
scale values is key; setting mu = c(1,1.2) will have the same effect on
the analysis as a value of mu =(c(0.5,0.6). The function returns a matrix 
of scale values of the same dimension as the number of samples
and the number of mc.samples used by the aldex() or aldex.clr()
function.
}
\examples{

# conditions is a vector describing the data
data(selex)
# subset for efficiency
conds <- c(rep("NS", 7), rep("S", 7))
mu.in <- c(1,50) # 50-fold difference in scale between groups
mu.vec <- aldex.makeScaleMatrix(1, mu.in, conds, log=TRUE, mc.samples=128)

}
\references{
Please use the citation given by \code{citation(package="ALDEx")}.
}
\seealso{
\code{\link{aldex.clr}}, \code{\link{aldex}}
}
\author{
Greg Gloor, Michelle Pistner Nixon
}
