% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clr_glm.r
\name{aldex.kw}
\alias{aldex.kw}
\title{Calculate the Kruskal-Wallis test and glm statistics}
\usage{
aldex.kw(clr, useMC = FALSE, verbose = FALSE)
}
\arguments{
\item{clr}{An \code{ALDEx2} object. The output of \code{aldex.clr}.}

\item{useMC}{Toggles whether to use multi-core.}

\item{verbose}{A boolean. Toggles whether to print diagnostic information while
running. Useful for debugging errors on large datasets. Applies to
\code{effect = TRUE}.}
}
\value{
Returns a \code{data.frame} with the following information:
\item{kw.ep}{ a vector containing the expected p-value of the Kruskal-Wallis test
 for each feature }
\item{kw.eBH}{ a vector containing the corresponding expected value of the
 Benjamini-Hochberg corrected p-value for each feature }
\item{glm.ep}{ a vector containing the expected p-value of the glm ANOVA
 for each feature }
\item{glm.eBH}{ a vector containing the corresponding expected value of the
 Benjamini-Hochberg corrected p-value for each feature. Note, you should use
 the aldex.glm function for better post-hoc test statistics. }
}
\description{
\code{aldex.kw} calculates the expected values of the Kruskal-Wallis
 test and a glm on the data returned by \code{aldex.clr}.
}
\details{
use the aldex.glm function unless you really need the nonparametric KW test
}
\examples{
data(selex)
#subset for efficiency
selex <- selex[1201:1600,]
conds <- c(rep("A", 4), rep("B", 3), rep("C", 7))
x <- aldex.clr(selex, conds, mc.samples=1, denom="all")
kw.test <- aldex.kw(x)
}
\references{
Please use the citation given by
 \code{citation(package="ALDEx2")}.
}
\seealso{
\code{\link{aldex}},
 \code{\link{aldex.clr}},
 \code{\link{aldex.ttest}},
 \code{\link{aldex.kw}},
 \code{\link{aldex.glm}},
 \code{\link{aldex.effect}},
 \code{\link{aldex.corr}},
 \code{\link{selex}}
}
\author{
Arianne Albert
}
