% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helper.R
\name{ReturnChoice}
\alias{ReturnChoice}
\title{Wrapper for return of EvaluateMethods()}
\usage{
ReturnChoice(sce, choice)
}
\arguments{
\item{sce}{SingleCellExperiment; a SingleCellExperiment object if available;
NULL otherwise}

\item{choice}{character; best performing method in the training set for each
gene}
}
\value{
\itemize{
    \item if \code{sce} is provided: returns a SingleCellExperiment with the
    best performing method per gene stored as row-features. Access via
    \code{SingleCellExperiment::int_elementMetadata(sce)$ADImpute$methods}.
    \item if \code{sce} is not provided: returns a character with the best
    performing method in the training set for each gene
}
}
\description{
\code{ReturnChoice} Adjusts the output of \code{EvaluateMethods}
to a character vector or a SingleCellExperiment object. Helper function to
ADImpute.
}
