% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Impute.R
\name{ImputeNetwork}
\alias{ImputeNetwork}
\title{Network-based imputation}
\usage{
ImputeNetwork(data, net.coef = NULL,
cores = BiocParallel::bpworkers(BPPARAM),
BPPARAM = BiocParallel::SnowParam(type = "SOCK"),
type = 'iteration', write = FALSE, ...)
}
\arguments{
\item{data}{matrix with entries equal to zero to be imputed, normalized
and log2-transformed (genes as rows and samples as columns)}

\item{net.coef}{matrix; network coefficients.}

\item{cores}{integer; number of cores to use}

\item{BPPARAM}{parallel back-end to be used during parallel computation.
See \code{\link[BiocParallel]{BiocParallelParam-class}}.}

\item{type}{character; either 'iteration', for an iterative solution, or
'pseudoinv', to use Moore-Penrose pseudo-inversion as a solution.}

\item{write}{logical; should a file with the imputation results be written?}

\item{...}{additional arguments to \code{ImputeNetParallel}}
}
\value{
matrix; imputation results incorporating network information
}
\description{
Network-based imputation
}
\details{
Imputes dropouts using a gene regulatory network trained on external
data, as provided in \code{net.coef}. Dropout expression values are
estimated from the expression of their predictor genes and the network
coefficients.
}
\seealso{
\code{\link{ImputeNetParallel}}
}
