% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wrap.R
\name{Impute}
\alias{Impute}
\title{Dropout imputation using different methods}
\usage{
Impute(data, sce = NULL, do = 'Ensemble', write = FALSE,
outdir = getwd(), method.choice = NULL, scale = 1, pseudo.count = 1,
labels = NULL, cell.clusters = 2, drop_thre = NULL, type = 'count',
tr.length = ADImpute::transcript_length,
cores = BiocParallel::bpworkers(BPPARAM),
BPPARAM = BiocParallel::SnowParam(type = "SOCK"),
net.coef = ADImpute::network.coefficients, net.implementation = 'iteration',
bulk = NULL, true.zero.thr = NULL, prob.mat = NULL, ...)
}
\arguments{
\item{data}{matrix; raw counts (genes as rows and samples as columns)}

\item{sce}{SingleCellExperiment; normalized counts and associated metadata.}

\item{do}{character; choice of methods to be used for imputation. Currently
supported methods are \code{'Baseline'}, \code{'DrImpute'},
\code{'Network'}, and \code{'Ensemble'}. Defaults to \code{'Ensemble'}.
Not case-sensitive. Can include one or more methods. Non-supported methods
will be ignored.}

\item{write}{logical; write intermediary and imputed objects to files?}

\item{outdir}{character; path to directory where output files are written.
Defaults to working directory}

\item{method.choice}{character; best performing method in training data for
each gene}

\item{scale}{integer; scaling factor to divide all expression levels by
(defaults to 1)}

\item{pseudo.count}{integer; pseudo-count to be added to expression levels
to avoid log(0) (defaults to 1)}

\item{labels}{character; vector specifying the cell type of each column of
\code{data}}

\item{cell.clusters}{integer; number of cell subpopulations}

\item{drop_thre}{numeric; between 0 and 1 specifying the threshold to
determine dropout values}

\item{type}{A character specifying the type of values in the expression
matrix. Can be 'count' or 'TPM'}

\item{tr.length}{matrix with at least 2 columns: 'hgnc_symbol' and
'transcript_length'}

\item{cores}{integer; number of cores used for paralell computation}

\item{BPPARAM}{parallel back-end to be used during parallel computation.
See \code{\link[BiocParallel]{BiocParallelParam-class}}.}

\item{net.coef}{matrix; network coefficients. Please provide if you don't
want to use ADImpute's network model. Must contain one first column 'O'
acconting for the intercept of the model and otherwise be an adjacency matrix
with hgnc_symbols in rows and columns. Doesn't have to be squared. See
\code{ADImpute::demo_net} for a small example.}

\item{net.implementation}{character; either 'iteration', for an iterative
solution, or 'pseudoinv', to use Moore-Penrose pseudo-inversion as a
solution. 'pseudoinv' is not advised for big data.}

\item{bulk}{vector of reference bulk RNA-seq, if available (average across
samples)}

\item{true.zero.thr}{if set to NULL (default), no true zero estimation is
performed. Set to numeric value between 0 and 1 for estimation. Value
corresponds to the threshold used to determine true zeros: if the probability
of dropout is lower than \code{true.zero.thr}, the imputed entries are set
to zero.}

\item{prob.mat}{matrix of the same size as data, filled with the dropout
probabilities for each gene in each cell}

\item{...}{additional parameters to pass to network-based imputation}
}
\value{
\itemize{
    \item if \code{sce} is not set: returns a list of imputation results
    (normalized, log-transformed) for all selected methods in \code{do}. If
    \code{true.zero.thr} is defined, returns a list of 3 elements: 1) a list,
    \code{imputations}, containing the direct imputation results from each
    method; 2) a list, \code{zerofiltered}, containing the results of
    imputation in \code{imputations} after setting biological zeros back to
    zero; 3) a matrix, \code{dropoutprobabilities}, containing the dropout
    probability matrix used to set biological zeros.
    \item if \code{sce} is set: returns a SingleCellExperiment with new
    assays, each corresponding to one of the imputation methods applied. If
    \code{true.zero.thr} is defined, the assays will contain the results
    after imputation and setting biological zeros back to zero.
}
}
\description{
\code{Impute} performs dropout imputation on normalized data,
based on the choice of imputation methods.
}
\details{
Values that are 0 in \code{data} are imputed according to the
best-performing methods indicated in \code{method.choice}. Currently
supported methods are:
\itemize{
    \item \code{Baseline}: imputation with average expression across all
cells in the dataset. See \code{\link{ImputeBaseline}}.
    \item Previously published approaches: \code{DrImpute} and \code{SAVER}.
    \item \code{Network}: leverages information from a gene regulatory
network to predicted expression of genes that are not quantified based on
quantified interacting genes, in the same cell. See
\code{\link{ImputeNetwork}}.
    \item \code{Ensemble}: is based on results on a training subset of the
data at hand, indicating which method best predicts the expression of
each gene. These results are supplied via \code{method.choice}. Applies
the imputation results of the best performing method to the zero entries
of each gene.
}
If \code{'Ensemble'} is included in \code{do}, \code{method.choice} has to
be provided (use output from \code{EvaluateMethods()}).
\code{Impute} can create a directory \code{imputation} containing the
imputation results of all methods in \code{do}.
If \code{true.zero.thr} is set, dropout probabilities are computed using
scImpute's framework. Expression values with dropout probabilities below
\code{true.zero.thr} will be set back to 0 if imputed, as they likely
correspond to true biological zeros (genes not expressed in cell) rather than
technical dropouts (genes expressed but not captured).
If \code{sce} is set, imputed values by the different methods are added as
new assays to \code{sce}. Each assay corresponds to one imputation method. If
\code{true.zero.thr} is set, only the values after filtering for biological
zeros will be added. This is different from the output if \code{sce} is not
set, where the original values before filtering and the dropout probability
matrix are returned.
}
\examples{
# Normalize demo data
norm_data <- NormalizeRPM(demo_data)
# Impute with particular method(s)
imputed_data <- Impute(do = 'Network', data = norm_data[,1:10],
net.coef = ADImpute::demo_net)
imputed_data <- Impute(do = 'Network', data = norm_data[,1:10],
net.implementation = 'pseudoinv', net.coef = ADImpute::demo_net)

}
\seealso{
\code{\link{EvaluateMethods}},
\code{\link{ImputeBaseline}},
\code{\link{ImputeDrImpute}},
\code{\link{ImputeNetwork}},
\code{\link{ImputeSAVER}}
}
