% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot,DAresult,ANY-method}
\alias{plot,DAresult,ANY-method}
\title{Plotting differential abundance analysis results}
\usage{
\S4method{plot}{DAresult,ANY}(x, n.label = 5)
}
\arguments{
\item{x}{analysis result in \code{DAresult} type}

\item{n.label}{Number of taxa to label on the plot. Note that no taxa will be labeled if
no DA taxa.}
}
\value{
A ggplot object of the volcano plot
}
\description{
Volcano plot of ADAPT results
}
\details{
The customized plot function for \code{DAresult} type object generates a volcano plot with
the differentially abundant taxa highlighted. The users can decide how many taxa with
the smallest p-values are labeled on the plot.
}
\examples{
data(ecc_saliva)
saliva_results <- adapt(input_data=ecc_saliva, cond.var="CaseStatus", 
       base.cond="Control", adj.var="Site")
plot(saliva_results, n.label=10)
}
