% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/functions.R
\name{callParameterwithoutReplicates}
\alias{callParameterwithoutReplicates}
\title{Calculate parameters for differential expression test base on absolute counts differences without replicates}
\usage{
callParameterwithoutReplicates(object)
}
\arguments{
\item{object}{a \code{\link{ABSDataSet}} object.}
}
\value{
A ABSDataSet object with absolute differences, basemean, mean of each group, variance,
log2 of foldchange, named as 'absD', 'baseMean', 'Amean', 'Bmean',
 'Variance' and 'foldChange', respectively. Use the \code{\link{results}} to get access it
}
\description{
Calculate parameters for each gene (the moderating basemean and dispersions), without replicates
}
\details{
buliding a pseudo group to esitimate parameter by mean difference. shifted and calculate a set of parameters from normalized counts table before \code{\link{callDEs}}
}
\note{
This function should run after \code{\link{normalFactors}} or providing size factors. This function firstly constructs an expression level depended fold-change cutoffs
and then separate the data into two groups. The group with fold-change less than cutoffs is used to training the dispersion. However, the cutoff might be too small when applied
on data set without or with less DEs. To avoid it, we set a prior value (0.5) to it.
}
\examples{
data(simuN5)
obj <- ABSDataSet(counts=(simuN5$counts)[,c(1,2)], groups=factor(c(1,2)))
obj <- normalFactors(obj)
obj <- callParameterwithoutReplicates(obj)
obj <- callDEs(obj)
head(results(obj))
}

