/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public abstract class AbstractFeatureHolder
implements FeatureHolder {
    protected transient ChangeSupport changeSupport = null;

    public void addChangeListener(ChangeListener changeListener) {
        this.generateChangeSupport(null);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(changeListener);
        }
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.generateChangeSupport(changeType);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(changeListener, changeType);
        }
    }

    public abstract int countFeatures();

    public Feature createFeature(Feature.Template template) throws BioException, ChangeVetoException {
        throw new ChangeVetoException("This FeatureHolder does not support creation of new Features.");
    }

    public abstract Iterator features();

    public FeatureHolder filter(FeatureFilter featureFilter, boolean bl) {
        SimpleFeatureHolder simpleFeatureHolder = new SimpleFeatureHolder();
        Iterator iterator = this.features();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            if (featureFilter.accept(feature)) {
                try {
                    simpleFeatureHolder.addFeature(feature);
                }
                catch (ChangeVetoException changeVetoException) {
                    throw new BioError("Assertion failed: Couldn't add a feature to my new FeatureHolder");
                }
            }
            if (!bl) continue;
            FeatureHolder featureHolder = feature.filter(featureFilter, bl);
            Iterator iterator2 = featureHolder.features();
            while (iterator2.hasNext()) {
                try {
                    simpleFeatureHolder.addFeature((Feature)iterator2.next());
                }
                catch (ChangeVetoException changeVetoException) {
                    throw new BioError(changeVetoException, "Assertion failure: Should be able to manipulate this FeatureHolder");
                }
            }
        }
        return simpleFeatureHolder;
    }

    protected void generateChangeSupport(ChangeType changeType) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(changeListener);
            }
        }
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(changeListener, changeType);
            }
        }
    }

    public void removeFeature(Feature feature) throws ChangeVetoException {
        throw new ChangeVetoException("This FeatureHolder does not support removal of Features.");
    }
}

