/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.twohead;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dp.BackPointer;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.DPMatrix;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.SimpleStatePath;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.StatePath;
import org.biojava.bio.dp.twohead.BackMatrixPairDPCursor;
import org.biojava.bio.dp.twohead.Cell;
import org.biojava.bio.dp.twohead.CellCalculator;
import org.biojava.bio.dp.twohead.CellCalculatorFactory;
import org.biojava.bio.dp.twohead.CellCalculatorFactoryMaker;
import org.biojava.bio.dp.twohead.EmissionCache;
import org.biojava.bio.dp.twohead.LightPairDPCursor;
import org.biojava.bio.dp.twohead.MatrixPairDPCursor;
import org.biojava.bio.dp.twohead.PairDPCursor;
import org.biojava.bio.dp.twohead.PairDPMatrix;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.DoubleAlphabet;
import org.biojava.bio.symbol.GappedSymbolList;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;

public class PairwiseDP
extends DP
implements Serializable {
    private final HashMap emissionCache;
    private final CellCalculatorFactory ccFactory;
    private static final int[] ia00 = new int[2];

    public PairwiseDP(MarkovModel markovModel, CellCalculatorFactoryMaker cellCalculatorFactoryMaker) throws IllegalSymbolException, IllegalTransitionException, BioException {
        super(markovModel);
        Alphabet alphabet = markovModel.emissionAlphabet();
        this.emissionCache = new HashMap();
        this.emissionCache.put(ScoreType.PROBABILITY, new EmissionCache(alphabet, this.getStates(), this.getDotStatesIndex(), ScoreType.PROBABILITY));
        this.emissionCache.put(ScoreType.ODDS, new EmissionCache(alphabet, this.getStates(), this.getDotStatesIndex(), ScoreType.ODDS));
        this.emissionCache.put(ScoreType.NULL_MODEL, new EmissionCache(alphabet, this.getStates(), this.getDotStatesIndex(), ScoreType.NULL_MODEL));
        this.ccFactory = cellCalculatorFactoryMaker.make(this);
    }

    public double backward(SymbolList[] symbolListArray, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        return this.backwardMatrix(symbolListArray, scoreType).getScore();
    }

    public DPMatrix backwardMatrix(SymbolList[] symbolListArray, DPMatrix dPMatrix, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        return this.backwardMatrix(symbolListArray, scoreType);
    }

    public DPMatrix backwardMatrix(SymbolList[] symbolListArray, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        if (symbolListArray.length != 2) {
            throw new IllegalArgumentException("This DP object only runs on pairs.");
        }
        this.lockModel();
        PairDPMatrix pairDPMatrix = new PairDPMatrix(this, symbolListArray[0], symbolListArray[1]);
        BackMatrixPairDPCursor backMatrixPairDPCursor = new BackMatrixPairDPCursor(symbolListArray[0], symbolListArray[1], 2, 2, pairDPMatrix, this.getEmissionCache(scoreType));
        CellCalculator cellCalculator = this.ccFactory.backwards(scoreType);
        double d = this.runFB(backMatrixPairDPCursor, cellCalculator);
        this.unlockModel();
        pairDPMatrix.setScore(d);
        return pairDPMatrix;
    }

    public double forward(SymbolList[] symbolListArray, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        if (symbolListArray.length != 2) {
            throw new IllegalArgumentException("This DP object only runs on pairs.");
        }
        this.lockModel();
        LightPairDPCursor lightPairDPCursor = new LightPairDPCursor(symbolListArray[0], symbolListArray[1], 2, 2, this.getStates().length, this.getEmissionCache(scoreType));
        CellCalculator cellCalculator = this.ccFactory.forwards(scoreType);
        double d = this.runFB(lightPairDPCursor, cellCalculator);
        this.unlockModel();
        return d;
    }

    public DPMatrix forwardMatrix(SymbolList[] symbolListArray, DPMatrix dPMatrix, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        return this.forwardMatrix(symbolListArray, scoreType);
    }

    public DPMatrix forwardMatrix(SymbolList[] symbolListArray, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        if (symbolListArray.length != 2) {
            throw new IllegalArgumentException("This DP object only runs on pairs.");
        }
        this.lockModel();
        PairDPMatrix pairDPMatrix = new PairDPMatrix(this, symbolListArray[0], symbolListArray[1]);
        MatrixPairDPCursor matrixPairDPCursor = new MatrixPairDPCursor(symbolListArray[0], symbolListArray[1], 2, 2, pairDPMatrix, this.getEmissionCache(scoreType));
        CellCalculator cellCalculator = this.ccFactory.forwards(scoreType);
        double d = this.runFB(matrixPairDPCursor, cellCalculator);
        pairDPMatrix.setScore(d);
        this.unlockModel();
        return pairDPMatrix;
    }

    private EmissionCache getEmissionCache(ScoreType scoreType) {
        return (EmissionCache)this.emissionCache.get(scoreType);
    }

    private Cell run(PairDPCursor pairDPCursor, CellCalculator cellCalculator) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        Cell[][] cellArray = pairDPCursor.press();
        if (pairDPCursor.hasNext()) {
            pairDPCursor.next(cellArray);
            cellCalculator.initialize(cellArray);
        }
        while (pairDPCursor.hasNext()) {
            pairDPCursor.next(cellArray);
            cellCalculator.calcCell(cellArray);
        }
        return cellArray[0][0];
    }

    private double runFB(PairDPCursor pairDPCursor, CellCalculator cellCalculator) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        Cell cell = this.run(pairDPCursor, cellCalculator);
        State[] stateArray = this.getStates();
        int n = 0;
        MagicalState magicalState = this.getModel().magicalState();
        while (stateArray[n] != magicalState) {
            ++n;
        }
        return cell.scores[n];
    }

    public void update() {
        super.update();
        if (this.emissionCache != null) {
            Iterator iterator = this.emissionCache.values().iterator();
            while (iterator.hasNext()) {
                ((EmissionCache)iterator.next()).clear();
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public StatePath viterbi(SymbolList[] var1_1, ScoreType var2_2) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        if (var1_1.length != 2) {
            throw new IllegalArgumentException("This DP object only runs on pairs.");
        }
        this.lockModel();
        var3_3 = var1_1[0];
        var4_4 = var1_1[1];
        var5_5 = this.getModel().magicalState();
        var6_6 = new BackPointer(var5_5);
        var7_7 = new LightPairDPCursor(var3_3, var4_4, 2, 2, this.getStates().length, this.getEmissionCache(var2_2));
        var8_8 = this.ccFactory.viterbi(var2_2, var6_6);
        var9_9 = this.run(var7_7, var8_8);
        var10_10 = 0;
        var11_11 = this.getStates();
        var12_12 = this.getModel().magicalState();
        while (var11_11[var10_10] != var12_12) {
            ++var10_10;
        }
        var13_13 = var9_9.backPointers;
        var14_14 = var13_13[var10_10];
        var15_15 = new ArrayList<State>();
        var16_16 = new ArrayList<E>();
        var17_17 = new GappedSymbolList(var3_3);
        var18_18 = new GappedSymbolList(var4_4);
        var19_19 = var3_3.length() + 1;
        var20_20 = var4_4.length() + 1;
        var21_21 = DoubleAlphabet.getInstance();
        var22_22 = var14_14.back;
        while (var22_22 != var6_6) {
            block13: {
                try {
                    var15_15.add(var22_22.state);
                    if (var22_22.state instanceof EmissionState) {
                        var23_23 /* !! */  = ((EmissionState)var22_22.state).getAdvance();
                        if (var23_23 /* !! */ [0] == false) {
                            var17_17.addGapInSource(var19_19);
                        } else {
                            --var19_19;
                        }
                        if (var23_23 /* !! */ [1] == false) {
                            var18_18.addGapInSource(var20_20);
                        } else {
                            --var20_20;
                        }
                    }
                    break block13;
                }
                catch (IndexOutOfBoundsException var23_24) {
                    ** while (var22_22 != var6_6)
                }
lbl-1000:
                // 1 sources

                {
                    var22_22 = var22_22.back;
                    continue;
                }
lbl46:
                // 1 sources

                throw new BioError(var23_24);
            }
            var22_22 = var22_22.back;
        }
        var23_23 /* !! */  = new double[var15_15.size()];
        var24_25 = new HashMap<SymbolList, GappedSymbolList>();
        var24_25.put(var3_3, var17_17);
        var24_25.put(var4_4, var18_18);
        var25_26 = new SimpleAlignment(var24_25);
        var26_27 = new GappedSymbolList(var25_26);
        var27_28 = var15_15.size() - 1;
        var28_29 = var25_26.length() + 1;
        var29_30 = var14_14.back;
        while (var29_30 != var6_6) {
            var23_23 /* !! */ [var27_28] = var29_30.score;
            if (!(var29_30.state instanceof EmissionState)) {
                var26_27.addGapInSource(var28_29);
                --var28_29;
            }
            --var27_28;
            var29_30 = var29_30.back;
        }
        Collections.reverse(var15_15);
        var30_31 = new SimpleSymbolList(this.getModel().stateAlphabet(), var15_15);
        var31_32 = DoubleAlphabet.fromArray(var23_23 /* !! */ );
        var32_33 = new SimpleStatePath(var9_9.scores[var10_10], var26_27, var30_31, var31_32);
        this.unlockModel();
        return var32_33;
    }
}

