/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.onehead;

import java.util.Iterator;
import org.biojava.bio.dp.onehead.AbstractCursor;
import org.biojava.bio.dp.onehead.SingleDPMatrix;
import org.biojava.bio.symbol.SymbolList;

class MatrixCursor
extends AbstractCursor {
    private final SingleDPMatrix matrix;
    private final int dir;
    private int index;

    public MatrixCursor(SingleDPMatrix singleDPMatrix, Iterator iterator, int n) throws IllegalArgumentException {
        super(iterator);
        this.matrix = singleDPMatrix;
        this.dir = n;
        this.index = n == 1 ? 0 : this.length() - 1;
    }

    public void advance() {
        super.advance();
        this.index += this.dir;
    }

    public double[] currentCol() {
        return this.matrix.scores[this.index];
    }

    public double[] lastCol() {
        return this.matrix.scores[this.index - this.dir];
    }

    public int length() {
        return this.matrix.symList()[0].length() + 2;
    }

    public SymbolList symList() {
        return this.matrix.symList()[0];
    }
}

