/*
 * Decompiled with CFR 0.152.
 */
package cern.colt;

import cern.colt.PersistentObject;

public class Timer
extends PersistentObject {
    private long baseTime;
    private long elapsedTime;
    private static final long UNIT = 1000L;

    public Timer() {
        this.reset();
    }

    public Timer display() {
        System.out.println(this);
        return this;
    }

    public float elapsedTime() {
        return this.seconds();
    }

    public long millis() {
        long l = this.elapsedTime;
        if (this.baseTime != 0L) {
            l += System.currentTimeMillis() - this.baseTime;
        }
        return l;
    }

    public Timer minus(Timer timer) {
        Timer timer2 = new Timer();
        timer2.elapsedTime = this.millis() - timer.millis();
        return timer2;
    }

    public float minutes() {
        return this.seconds() / 60.0f;
    }

    public Timer plus(Timer timer) {
        Timer timer2 = new Timer();
        timer2.elapsedTime = this.millis() + timer.millis();
        return timer2;
    }

    public Timer reset() {
        this.elapsedTime = 0L;
        this.baseTime = 0L;
        return this;
    }

    public float seconds() {
        return (float)this.millis() / 1000.0f;
    }

    public Timer start() {
        this.baseTime = System.currentTimeMillis();
        return this;
    }

    public Timer stop() {
        if (this.baseTime != 0L) {
            this.elapsedTime += System.currentTimeMillis() - this.baseTime;
        }
        this.baseTime = 0L;
        return this;
    }

    public static void test(int n) {
        Timer timer = new Timer().start();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            ++n2;
            ++n3;
        }
        timer.stop();
        timer.display();
        System.out.println("I finished the test using " + timer);
        n2 = 0;
        int n4 = 0;
        while (n4 < n) {
            ++n2;
            ++n4;
        }
        timer.start();
        n2 = 0;
        int n5 = 0;
        while (n5 < n) {
            ++n2;
            ++n5;
        }
        timer.stop().display();
        timer.reset();
        timer.start();
        n2 = 0;
        int n6 = 0;
        while (n6 < n) {
            ++n2;
            ++n6;
        }
        timer.stop().display();
    }

    public String toString() {
        return "Time=" + Float.toString(this.elapsedTime()) + " secs";
    }
}

