## ----echo=FALSE, error=FALSE--------------------------------------------------
if (!require("ggplot2", quietly = TRUE)) {
  stop("The 'ggplot2' package must be installed for this functionality")
}

## ----echo=FALSE, dpi=300, fig.width=6, fig.height=4, fig.align="center", fig.cap="Effect of htslib v1.18 source on iscream's 'make_mat()' runtime from one bulk WGBS BED file"----
data_dir <- system.file("extdata", package = "iscream")
df <- read.csv(file.path(data_dir, "htslib.csv"))
ggplot(df, aes(x = regions, y = time, color = source)) +
  geom_point(alpha = 0.8) +
  stat_summary(
    aes(x = regions, group = source),
    fun = "mean",
    geom = "line",
    linewidth = 0.5,
    show.legend = TRUE
  ) +
  labs(
    x = "Genomic regions",
    y = "Runtime (s)",
    color = "htslib source"
  ) +
  theme_bw()



## ----si-----------------------------------------------------------------------
sessionInfo()

